/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.messages.Channel;
import com.vonage.client.messages.MessageStatus;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.sms.SmsInboundMetadata;
import com.vonage.client.messages.whatsapp.Context;
import com.vonage.client.messages.whatsapp.Location;
import com.vonage.client.messages.whatsapp.Order;
import com.vonage.client.messages.whatsapp.Profile;
import com.vonage.client.messages.whatsapp.Reply;
import java.io.IOException;
import java.net.URI;
import java.time.Instant;
import java.util.Map;
import java.util.UUID;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InboundMessage {
    @JsonAnySetter
    protected Map<String, Object> unknownProperties;
    @JsonProperty(value="timestamp")
    protected Instant timestamp;
    @JsonProperty(value="channel")
    protected Channel channel;
    @JsonProperty(value="message_type")
    protected MessageType messageType;
    @JsonProperty(value="message_uuid")
    protected UUID messageUuid;
    @JsonProperty(value="to")
    protected String to;
    @JsonProperty(value="from")
    protected String from;
    @JsonProperty(value="client_ref")
    protected String clientRef;
    @JsonProperty(value="provider_message")
    String providerMessage;
    @JsonProperty(value="text")
    protected String text;
    @JsonProperty(value="image")
    protected UrlWrapper image;
    @JsonProperty(value="audio")
    protected UrlWrapper audio;
    @JsonProperty(value="video")
    protected UrlWrapper video;
    @JsonProperty(value="file")
    protected UrlWrapper file;
    @JsonProperty(value="vcard")
    protected UrlWrapper vcard;
    @JsonProperty(value="sticker")
    protected UrlWrapper sticker;
    @JsonProperty(value="profile")
    protected Profile whatsappProfile;
    @JsonProperty(value="context")
    protected Context whatsappContext;
    @JsonProperty(value="location")
    protected Location whatsappLocation;
    @JsonProperty(value="reply")
    protected Reply whatsappReply;
    @JsonProperty(value="order")
    protected Order whatsappOrder;
    @JsonProperty(value="usage")
    protected MessageStatus.Usage usage;
    @JsonProperty(value="sms")
    protected SmsInboundMetadata smsMetadata;

    protected InboundMessage() {
    }

    @JsonAnyGetter
    public Map<String, ?> getUnmappedProperties() {
        return this.unknownProperties;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public UUID getMessageUuid() {
        return this.messageUuid;
    }

    public String getTo() {
        return this.to;
    }

    public String getFrom() {
        return this.from;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public String getClientRef() {
        return this.clientRef;
    }

    public String getText() {
        return this.text;
    }

    public URI getImageUrl() {
        return this.image != null ? this.image.url : null;
    }

    public URI getAudioUrl() {
        return this.audio != null ? this.audio.url : null;
    }

    public URI getVideoUrl() {
        return this.video != null ? this.video.url : null;
    }

    public URI getFileUrl() {
        return this.file != null ? this.file.url : null;
    }

    public URI getVcardUrl() {
        return this.vcard != null ? this.vcard.url : null;
    }

    public URI getStickerUrl() {
        return this.sticker != null ? this.sticker.url : null;
    }

    public String getProviderMessage() {
        return this.providerMessage;
    }

    public Location getWhatsappLocation() {
        return this.whatsappLocation;
    }

    public Reply getWhatsappReply() {
        return this.whatsappReply;
    }

    public Order getWhatsappOrder() {
        return this.whatsappOrder;
    }

    public Profile getWhatsappProfile() {
        return this.whatsappProfile;
    }

    public Context getWhatsappContext() {
        return this.whatsappContext;
    }

    public MessageStatus.Usage getUsage() {
        return this.usage;
    }

    public SmsInboundMetadata getSmsMetadata() {
        return this.smsMetadata;
    }

    public static InboundMessage fromJson(String json) {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JavaTimeModule());
            return (InboundMessage)mapper.readValue(json, InboundMessage.class);
        }
        catch (IOException ex) {
            throw new VonageUnexpectedException("Failed to produce InboundMessage from json.", ex);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    protected static class UrlWrapper {
        @JsonProperty(value="url")
        protected URI url;

        protected UrlWrapper() {
        }
    }
}

