/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.viber.Action;
import com.vonage.client.messages.viber.Category;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ViberService {
    private final Category category;
    private final Integer ttl;
    private final String type;
    private final Action action;

    private ViberService(Category category, Integer ttl, String type, Action action) {
        this.category = category;
        this.ttl = ttl;
        this.type = type;
        this.action = action;
    }

    static ViberService construct(Category category, Integer ttl, String type, Action action) {
        if (category == null && ttl == null && type == null && action == null) {
            return null;
        }
        if (ttl != null && (ttl < 30 || ttl > 259200)) {
            throw new IllegalArgumentException("Time-to-live (ttl) must be between 30 and 259200 seconds");
        }
        return new ViberService(category, ttl, type, action);
    }

    @JsonProperty(value="category")
    public Category getCategory() {
        return this.category;
    }

    @JsonProperty(value="ttl")
    public Integer getTtl() {
        return this.ttl;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="action")
    public Action getAction() {
        return this.action;
    }
}

