/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.viber;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.internal.MessagePayload;
import java.net.URI;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Video
extends MessagePayload {
    protected URI thumbUrl;

    protected Video(String url, String thumbUrl, String caption) {
        super(url, caption);
        this.thumbUrl = URI.create(Objects.requireNonNull(thumbUrl, "Thumbnail URL is required"));
        this.validateFileExtensions();
    }

    @JsonProperty(value="thumb_url")
    public URI getThumbUrl() {
        return this.thumbUrl;
    }

    protected void validateFileExtensions() {
        this.validateUrlExtension("mp4", "3gpp");
        Video.validateExtension(this.thumbUrl.getPath(), "jpg", "jpeg", "png", "bmp", "gif");
    }
}

