/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.whatsapp.ProductItem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
final class ProductSection {
    @JsonProperty(value="title")
    final String title;
    @JsonProperty(value="product_items")
    final List<ProductItem> products;

    public ProductSection(String title, List<String> products) {
        this.title = Objects.requireNonNull(title, "Section title is required.");
        if (products == null || products.isEmpty()) {
            throw new IllegalArgumentException("At least one product is required for each section.");
        }
        this.products = products.stream().map(ProductItem::new).collect(Collectors.toList());
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="product_items")
    public List<ProductItem> getProducts() {
        return this.products;
    }
}

