/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.MessagePayload;
import com.vonage.client.messages.whatsapp.WhatsappRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WhatsappAudioRequest
extends WhatsappRequest {
    final MessagePayload audio;

    WhatsappAudioRequest(Builder builder) {
        super(builder, MessageType.AUDIO);
        this.audio = new MessagePayload(builder.url);
        this.audio.validateUrlExtension("aac", "m4a", "amr", "mp3", "opus");
        this.audio.validateUrlLength(10, 2000);
    }

    @JsonProperty(value="audio")
    public MessagePayload getAudio() {
        return this.audio;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappAudioRequest, Builder> {
        String url;

        Builder() {
        }

        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Override
        public WhatsappAudioRequest build() {
            return new WhatsappAudioRequest(this);
        }
    }
}

