/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.whatsapp.ProductSection;
import com.vonage.client.messages.whatsapp.WhatsappRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WhatsappMultiProductRequest
extends WhatsappRequest {
    final Map<String, Object> custom;

    WhatsappMultiProductRequest(Builder builder) {
        super(builder, MessageType.CUSTOM);
        LinkedHashMap<String, Object> interactive = new LinkedHashMap<String, Object>(8);
        interactive.put("type", "product_list");
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>(4);
        header.put("type", "text");
        header.put("text", Objects.requireNonNull(builder.headerText, "Header text is required."));
        interactive.put("header", header);
        interactive.put("body", Collections.singletonMap("text", Objects.requireNonNull(builder.bodyText, "Body text is required.")));
        if (builder.footerText != null) {
            interactive.put("footer", Collections.singletonMap("text", builder.footerText));
        }
        LinkedHashMap<String, Object> action = new LinkedHashMap<String, Object>(4);
        action.put("catalog_id", Objects.requireNonNull(builder.catalogId, "Catalog ID is required."));
        if (builder.sections.isEmpty()) {
            throw new IllegalStateException("At least one product section should be specified.");
        }
        action.put("sections", builder.sections);
        interactive.put("action", action);
        this.custom = new LinkedHashMap<String, Object>(4);
        this.custom.put("type", "interactive");
        this.custom.put("interactive", interactive);
    }

    @JsonProperty(value="custom")
    public Map<?, ?> getCustom() {
        return this.custom;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappMultiProductRequest, Builder> {
        String bodyText;
        String headerText;
        String footerText;
        String catalogId;
        final List<ProductSection> sections = new ArrayList<ProductSection>();

        Builder() {
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public Builder addProductsSection(String title, List<String> skus) {
            this.sections.add(new ProductSection(title, skus));
            return this;
        }

        public Builder addProductsSection(String title, String ... skus) {
            return this.addProductsSection(title, Arrays.asList(skus));
        }

        public Builder headerText(String headerText) {
            this.headerText = headerText;
            return this;
        }

        public Builder bodyText(String bodyText) {
            this.bodyText = bodyText;
            return this;
        }

        public Builder footerText(String footerText) {
            this.footerText = footerText;
            return this;
        }

        @Override
        public WhatsappMultiProductRequest build() {
            return new WhatsappMultiProductRequest(this);
        }
    }
}

