/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.messages.whatsapp;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.messages.MessageType;
import com.vonage.client.messages.internal.Text;
import com.vonage.client.messages.whatsapp.WhatsappRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class WhatsappTextRequest
extends WhatsappRequest {
    final String text;

    WhatsappTextRequest(Builder builder) {
        super(builder, MessageType.TEXT);
        this.text = new Text(builder.text, 4096).toString();
    }

    @JsonProperty(value="text")
    public String getText() {
        return this.text;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends WhatsappRequest.Builder<WhatsappTextRequest, Builder> {
        String text;

        Builder() {
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public WhatsappTextRequest build() {
            return new WhatsappTextRequest(this);
        }
    }
}

