/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.numbers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Type {
    LANDLINE("landline"),
    MOBILE_LVN("mobile-lvn"),
    LANDLINE_TOLL_FREE("landline-toll-free"),
    UNKNOWN("unknown");

    private static final Map<String, Type> TYPE_INDEX;
    private final String type;

    private Type(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static Type fromString(String type) {
        return TYPE_INDEX.getOrDefault(type, UNKNOWN);
    }

    static {
        TYPE_INDEX = Arrays.stream(Type.values()).collect(Collectors.toMap(Type::getType, Function.identity()));
    }
}

