/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.sms.SmsSubmissionResponse;
import com.vonage.client.sms.messages.Message;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;

class SendMessageEndpoint
extends AbstractMethod<Message, SmsSubmissionResponse> {
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/sms/json";

    SendMessageEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(Message message) throws UnsupportedEncodingException {
        RequestBuilder request = RequestBuilder.post((String)(this.httpWrapper.getHttpConfig().getRestBaseUri() + PATH)).setHeader("Content-Type", "application/x-www-form-urlencoded").setHeader("Accept", "application/json");
        message.addParams(request);
        return request;
    }

    @Override
    public SmsSubmissionResponse parseResponse(HttpResponse response) throws IOException {
        return SmsSubmissionResponse.fromJson(basicResponseHandler.handleResponse(response));
    }
}

