/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sms.messages;

import com.vonage.client.sms.HexUtil;
import com.vonage.client.sms.messages.Message;
import org.apache.http.client.methods.RequestBuilder;

public class BinaryMessage
extends Message {
    private final byte[] messageBody;
    private final byte[] udh;
    private int protocolId = 0;

    public BinaryMessage(String from, String to, byte[] messageBody, byte[] udh) {
        super(Message.MessageType.BINARY, from, to);
        this.messageBody = messageBody;
        this.udh = udh;
    }

    public byte[] getMessageBody() {
        return this.messageBody == null ? null : (byte[])this.messageBody.clone();
    }

    public byte[] getUdh() {
        return this.udh == null ? null : (byte[])this.udh.clone();
    }

    public int getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(int protocolId) {
        this.protocolId = protocolId;
    }

    @Override
    public void addParams(RequestBuilder request) {
        super.addParams(request);
        request.addParameter("udh", HexUtil.bytesToHex(this.getUdh())).addParameter("body", HexUtil.bytesToHex(this.getMessageBody())).addParameter("protocol-id", Integer.toString(this.protocolId));
    }
}

