/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.sns;

import com.vonage.client.AbstractMethod;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.legacyutils.XmlParser;
import com.vonage.client.legacyutils.XmlUtil;
import com.vonage.client.sns.SnsClient;
import com.vonage.client.sns.request.SnsRequest;
import com.vonage.client.sns.response.SnsPublishResponse;
import com.vonage.client.sns.response.SnsResponse;
import com.vonage.client.sns.response.SnsSubscribeResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.RequestBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SnsEndpoint
extends AbstractMethod<SnsRequest, SnsResponse> {
    private static final Log log = LogFactory.getLog(SnsClient.class);
    private static final Class<?>[] ALLOWED_AUTH_METHODS = new Class[]{SignatureAuthMethod.class, TokenAuthMethod.class};
    private static final String PATH = "/sns/xml";
    private final XmlParser xmlParser = new XmlParser();

    SnsEndpoint(HttpWrapper httpWrapper) {
        super(httpWrapper);
    }

    @Override
    protected Class<?>[] getAcceptableAuthMethods() {
        return ALLOWED_AUTH_METHODS;
    }

    @Override
    public RequestBuilder makeRequest(SnsRequest snsRequest) throws UnsupportedEncodingException {
        String uri = this.httpWrapper.getHttpConfig().getSnsBaseUri() + PATH;
        RequestBuilder requestBuilder = RequestBuilder.post((String)uri).addParameter("cmd", snsRequest.getCommand());
        for (Map.Entry<String, String> entry : snsRequest.getQueryParameters().entrySet()) {
            requestBuilder.addParameter(entry.getKey(), entry.getValue());
        }
        return requestBuilder;
    }

    @Override
    public SnsResponse parseResponse(HttpResponse response) throws IOException {
        return this.parseSubmitResponse(basicResponseHandler.handleResponse(response));
    }

    protected SnsResponse parseSubmitResponse(String response) {
        Document doc = this.xmlParser.parseXml(response);
        String command = null;
        int resultCode = -1;
        String resultMessage = null;
        String transactionId = null;
        String subscriberArn = null;
        NodeList replies = doc.getElementsByTagName("nexmo-sns");
        Node reply = replies.item(0);
        NodeList nodes = reply.getChildNodes();
        block16: for (int i2 = 0; i2 < nodes.getLength(); ++i2) {
            Node node = nodes.item(i2);
            if (node.getNodeType() != 1) continue;
            switch (node.getNodeName()) {
                case "command": {
                    command = XmlUtil.stringValue(node);
                    continue block16;
                }
                case "resultCode": {
                    try {
                        resultCode = XmlUtil.intValue(node);
                    }
                    catch (Exception e) {
                        log.error((Object)("xml parser .. invalid value in <resultCode> node [ " + XmlUtil.stringValue(node) + " ] "));
                        resultCode = 2;
                    }
                    continue block16;
                }
                case "resultMessage": {
                    resultMessage = XmlUtil.stringValue(node);
                    continue block16;
                }
                case "transactionId": {
                    transactionId = XmlUtil.stringValue(node);
                    continue block16;
                }
                case "subscriberArn": {
                    subscriberArn = XmlUtil.stringValue(node);
                    continue block16;
                }
                default: {
                    log.error((Object)("xml parser .. unknown node found in nexmo-sns [ " + node.getNodeName() + " ] "));
                }
            }
        }
        if (resultCode == -1) {
            throw new VonageResponseParseException("Xml Parser - did not find a <resultCode> node");
        }
        if ("publish".equals(command)) {
            return new SnsPublishResponse(resultCode, resultMessage, transactionId);
        }
        if ("subscribe".equals(command)) {
            return new SnsSubscribeResponse(resultCode, resultMessage, subscriberArn);
        }
        throw new VonageResponseParseException("Unknown command value: " + command);
    }
}

