/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.voice.ModifyCallAction;
import com.vonage.client.voice.ModifyCallPayload;
import com.vonage.client.voice.TransferCallPayload;
import com.vonage.client.voice.ncco.Ncco;

public class CallModifier {
    private final String uuid;
    private final ModifyCallPayload modifyCallPayload;

    public CallModifier(String uuid, ModifyCallPayload modifyCallPayload) {
        this.uuid = uuid;
        this.modifyCallPayload = modifyCallPayload;
    }

    public CallModifier(String uuid, ModifyCallAction action) {
        this.uuid = uuid;
        this.modifyCallPayload = new ModifyCallPayload(action);
    }

    public static CallModifier transferCall(String uuid, String nccoUrl) {
        return new CallModifier(uuid, new TransferCallPayload(nccoUrl));
    }

    public static CallModifier transferCall(String uuid, Ncco ncco) {
        return new CallModifier(uuid, new TransferCallPayload(ncco));
    }

    public String getUuid() {
        return this.uuid;
    }

    public ModifyCallAction getAction() {
        return this.modifyCallPayload.getAction();
    }

    public String toJson() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            return mapper.writeValueAsString((Object)this.modifyCallPayload);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce json from CallModifier object.", jpe);
        }
    }
}

