/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.vonage.client.voice.TextToSpeechLanguage;
import com.vonage.client.voice.ncco.Action;
import com.vonage.client.voice.ncco.PaymentPrompt;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Deprecated
public class PayAction
implements Action {
    private static final String ACTION = "pay";
    private Collection<URI> eventUrl;
    private String currency;
    private Double amount;
    private Voice voice;
    private Collection<PaymentPrompt> prompts;

    PayAction() {
    }

    private PayAction(Builder builder) {
        this.amount = builder.amount;
        if (this.amount == null) {
            throw new IllegalStateException("Payment amount is mandatory.");
        }
        if (builder.currency != null) {
            this.currency = builder.currency.getCurrencyCode().toLowerCase();
        }
        if (builder.language != null || builder.style != null) {
            this.voice = new Voice(builder.language, builder.style);
        }
        this.eventUrl = builder.eventUrl;
        this.prompts = builder.prompts;
    }

    @Override
    public String getAction() {
        return ACTION;
    }

    public Collection<URI> getEventUrl() {
        return this.eventUrl;
    }

    public String getCurrency() {
        return this.currency;
    }

    public double getAmount() {
        return this.amount;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public Collection<PaymentPrompt> getPrompts() {
        return this.prompts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Collection<URI> eventUrl;
        private Collection<PaymentPrompt> prompts;
        private Currency currency;
        private Double amount;
        private TextToSpeechLanguage language;
        private Integer style;

        Builder() {
        }

        public Builder eventUrl(URI eventUrl) {
            if (this.eventUrl == null) {
                this.eventUrl = new ArrayList<URI>(1);
            }
            this.eventUrl.add(eventUrl);
            return this;
        }

        public Builder eventUrl(String eventUrl) {
            return this.eventUrl(URI.create(eventUrl));
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder currency(String currencyCode) {
            return this.currency(Currency.getInstance(currencyCode.toUpperCase()));
        }

        public Builder amount(double amount) {
            this.amount = amount;
            return this;
        }

        public Builder language(TextToSpeechLanguage language) {
            this.language = language;
            return this;
        }

        public Builder style(int style) {
            this.style = style;
            return this;
        }

        public Builder prompts(Collection<PaymentPrompt> prompts) {
            this.prompts = prompts;
            return this;
        }

        public PayAction build() {
            return new PayAction(this);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Voice {
        private final TextToSpeechLanguage language;
        private final Integer style;

        public Voice(TextToSpeechLanguage language, Integer style) {
            this.language = language;
            this.style = style;
        }

        public TextToSpeechLanguage getLanguage() {
            return this.language;
        }

        public Integer getStyle() {
            return this.style;
        }
    }
}

