/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.voice.ncco;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;

@Deprecated
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PaymentPrompt {
    private final Type type;
    private final String text;
    private final Errors errors;

    private PaymentPrompt(Builder builder) {
        this.type = builder.type;
        this.text = builder.text;
        this.errors = builder.errors;
    }

    public Type getType() {
        return this.type;
    }

    public String getText() {
        return this.text;
    }

    public Errors getErrors() {
        return this.errors;
    }

    public static Builder builder(Type type) {
        return new Builder(type);
    }

    public static class Builder {
        private final Type type;
        private String text;
        private Errors errors;

        Builder(Type type) {
            this.type = type;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        private Errors initErrors() {
            if (this.errors == null) {
                this.errors = new Errors();
            }
            return this.errors;
        }

        public Builder timeout(String errorText) {
            this.initErrors().timeout = new Errors.Timeout(errorText);
            return this;
        }

        public Builder invalidCardNumber(String errorText) {
            this.initErrors().invalidCardNumber = new Errors.InvalidCardNumber(errorText);
            return this;
        }

        public Builder invalidCardType(String errorText) {
            this.initErrors().invalidCardType = new Errors.InvalidCardType(errorText);
            return this;
        }

        public Builder invalidExpirationDate(String errorText) {
            this.initErrors().invalidExpirationDate = new Errors.InvalidExpirationDate(errorText);
            return this;
        }

        public Builder invalidSecurityCode(String errorText) {
            this.initErrors().invalidSecurityCode = new Errors.InvalidSecurityCode(errorText);
            return this;
        }

        public PaymentPrompt build() {
            return new PaymentPrompt(this);
        }
    }

    public static enum Type {
        CARD_NUMBER,
        EXPIRATION_DATE,
        SECURITY_CODE;


        @JsonValue
        public String toString() {
            String[] parts = this.name().split("_");
            StringBuilder jsonValue = new StringBuilder();
            for (String part : parts) {
                jsonValue.append(part.charAt(0)).append(part.substring(1).toLowerCase());
            }
            return jsonValue.toString();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Errors {
        @JsonProperty(value="Timeout")
        Timeout timeout;
        @JsonProperty(value="InvalidCardNumber")
        InvalidCardNumber invalidCardNumber;
        @JsonProperty(value="InvalidCardType")
        InvalidCardType invalidCardType;
        @JsonProperty(value="InvalidExpirationDate")
        InvalidExpirationDate invalidExpirationDate;
        @JsonProperty(value="InvalidSecurityCode")
        InvalidSecurityCode invalidSecurityCode;

        Errors() {
        }

        public Timeout getTimeout() {
            return this.timeout;
        }

        public InvalidCardNumber getInvalidCardNumber() {
            return this.invalidCardNumber;
        }

        public InvalidCardType getInvalidCardType() {
            return this.invalidCardType;
        }

        public InvalidExpirationDate getInvalidExpirationDate() {
            return this.invalidExpirationDate;
        }

        public InvalidSecurityCode getInvalidSecurityCode() {
            return this.invalidSecurityCode;
        }

        public static class Timeout
        extends Error {
            public Timeout(String text) {
                super(text);
            }
        }

        public static class InvalidCardNumber
        extends Error {
            public InvalidCardNumber(String text) {
                super(text);
            }
        }

        public static class InvalidCardType
        extends Error {
            public InvalidCardType(String text) {
                super(text);
            }
        }

        public static class InvalidExpirationDate
        extends Error {
            public InvalidExpirationDate(String text) {
                super(text);
            }
        }

        public static class InvalidSecurityCode
        extends Error {
            public InvalidSecurityCode(String text) {
                super(text);
            }
        }

        public static abstract class Error {
            private final String text;

            protected Error(String text) {
                this.text = text;
            }

            public String getText() {
                return this.text;
            }
        }
    }
}

