/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.jwt;

import com.vonage.jwt.DateClaimDelegate;
import com.vonage.jwt.JwtGenerator;
import com.vonage.jwt.StringClaimDelegate;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SignatureException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002%&B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\tR\u001b\u0010\u0018\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u0019\u0010\u0011R\u001b\u0010\u001b\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001c\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\tR\u001b\u0010\u001f\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0017\u001a\u0004\b \u0010\t\u00a8\u0006'"}, d2={"Lcom/vonage/jwt/Jwt;", "", "applicationId", "", "privateKeyContents", "claims", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplicationId", "()Ljava/lang/String;", "getClaims", "()Ljava/util/Map;", "setClaims", "(Ljava/util/Map;)V", "expiresAt", "Ljava/time/ZonedDateTime;", "getExpiresAt", "()Ljava/time/ZonedDateTime;", "expiresAt$delegate", "Lcom/vonage/jwt/DateClaimDelegate;", "id", "getId", "id$delegate", "Lcom/vonage/jwt/StringClaimDelegate;", "issuedAt", "getIssuedAt", "issuedAt$delegate", "notBefore", "getNotBefore", "notBefore$delegate", "getPrivateKeyContents", "subject", "getSubject", "subject$delegate", "generate", "jwtGenerator", "Lcom/vonage/jwt/JwtGenerator;", "Builder", "Companion", "jwt"})
public final class Jwt {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String privateKeyContents;
    @NotNull
    private Map<String, ? extends Object> claims;
    @NotNull
    private final DateClaimDelegate issuedAt$delegate;
    @NotNull
    private final StringClaimDelegate id$delegate;
    @NotNull
    private final DateClaimDelegate notBefore$delegate;
    @NotNull
    private final DateClaimDelegate expiresAt$delegate;
    @NotNull
    private final StringClaimDelegate subject$delegate;

    private Jwt(String applicationId, String privateKeyContents, Map<String, ? extends Object> claims) {
        this.applicationId = applicationId;
        this.privateKeyContents = privateKeyContents;
        this.claims = claims;
        this.issuedAt$delegate = new DateClaimDelegate();
        this.id$delegate = new StringClaimDelegate();
        this.notBefore$delegate = new DateClaimDelegate();
        this.expiresAt$delegate = new DateClaimDelegate();
        this.subject$delegate = new StringClaimDelegate();
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPrivateKeyContents() {
        return this.privateKeyContents;
    }

    @NotNull
    public final Map<String, Object> getClaims() {
        return this.claims;
    }

    public final void setClaims(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.claims = map;
    }

    @NotNull
    public final ZonedDateTime getIssuedAt() {
        return this.issuedAt$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @NotNull
    public final String getId() {
        return this.id$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @NotNull
    public final ZonedDateTime getNotBefore() {
        return this.notBefore$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @NotNull
    public final ZonedDateTime getExpiresAt() {
        return this.expiresAt$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @NotNull
    public final String getSubject() {
        return this.subject$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @JvmOverloads
    @NotNull
    public final String generate(@NotNull JwtGenerator jwtGenerator) {
        Intrinsics.checkNotNullParameter((Object)jwtGenerator, (String)"jwtGenerator");
        return jwtGenerator.generate(this);
    }

    public static /* synthetic */ String generate$default(Jwt jwt, JwtGenerator jwtGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            jwtGenerator = new JwtGenerator(null, 1, null);
        }
        return jwt.generate(jwtGenerator);
    }

    @JvmOverloads
    @NotNull
    public final String generate() {
        return Jwt.generate$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @JvmStatic
    public static final boolean verifySignature(@NotNull String token, @NotNull String secret) {
        return Companion.verifySignature(token, secret);
    }

    public /* synthetic */ Jwt(String applicationId, String privateKeyContents, Map claims, DefaultConstructorMarker $constructor_marker) {
        this(applicationId, privateKeyContents, claims);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Jwt.class, "issuedAt", "getIssuedAt()Ljava/time/ZonedDateTime;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Jwt.class, "id", "getId()Ljava/lang/String;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Jwt.class, "notBefore", "getNotBefore()Ljava/time/ZonedDateTime;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Jwt.class, "expiresAt", "getExpiresAt()Ljava/time/ZonedDateTime;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Jwt.class, "subject", "getSubject()Ljava/lang/String;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\n\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0001J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u0007\u001a\u00020\u00002\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0012J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/vonage/jwt/Jwt$Builder;", "", "applicationId", "", "privateKeyContents", "signed", "", "claims", "", "(Ljava/lang/String;Ljava/lang/String;ZLjava/util/Map;)V", "addClaim", "key", "value", "build", "Lcom/vonage/jwt/Jwt;", "", "expiresAt", "exp", "Ljava/time/ZonedDateTime;", "id", "jti", "issuedAt", "iat", "notBefore", "nbf", "privateKeyPath", "Ljava/nio/file/Path;", "subject", "unsigned", "validate", "", "jwt"})
    @SourceDebugExtension(value={"SMAP\nJwt.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Jwt.kt\ncom/vonage/jwt/Jwt$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1#2:166\n*E\n"})
    public static final class Builder {
        @NotNull
        private String applicationId;
        @NotNull
        private String privateKeyContents;
        private boolean signed;
        @NotNull
        private Map<String, Object> claims;

        public Builder(@NotNull String applicationId, @NotNull String privateKeyContents, boolean signed, @NotNull Map<String, Object> claims) {
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Intrinsics.checkNotNullParameter((Object)privateKeyContents, (String)"privateKeyContents");
            Intrinsics.checkNotNullParameter(claims, (String)"claims");
            this.applicationId = applicationId;
            this.privateKeyContents = privateKeyContents;
            this.signed = signed;
            this.claims = claims;
        }

        public /* synthetic */ Builder(String string, String string2, boolean bl, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                map = new LinkedHashMap();
            }
            this(string, string2, bl, map);
        }

        @NotNull
        public final Builder applicationId(@NotNull String applicationId) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
            Builder $this$applicationId_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$applicationId_u24lambda_u240.applicationId = applicationId;
            return builder;
        }

        @NotNull
        public final Builder unsigned() {
            Builder builder;
            Builder $this$unsigned_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$unsigned_u24lambda_u241.signed = false;
            return builder;
        }

        @NotNull
        public final Builder privateKeyContents(@NotNull String privateKeyContents) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)privateKeyContents, (String)"privateKeyContents");
            Builder $this$privateKeyContents_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$privateKeyContents_u24lambda_u242.privateKeyContents = privateKeyContents;
            $this$privateKeyContents_u24lambda_u242.signed = !StringsKt.isBlank((CharSequence)privateKeyContents);
            return builder;
        }

        @NotNull
        public final Builder privateKeyPath(@NotNull Path privateKeyPath) {
            Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
            byte[] byArray = Files.readAllBytes(privateKeyPath);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            byte[] byArray2 = byArray;
            return this.privateKeyContents(new String(byArray2, Charsets.UTF_8));
        }

        @NotNull
        public final Builder privateKeyPath(@NotNull String privateKeyPath) {
            Intrinsics.checkNotNullParameter((Object)privateKeyPath, (String)"privateKeyPath");
            Path path = Paths.get(privateKeyPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return this.privateKeyPath(path);
        }

        @NotNull
        public final Builder claims(@NotNull Map<String, ? extends Object> claims) {
            Builder builder;
            Intrinsics.checkNotNullParameter(claims, (String)"claims");
            Builder $this$claims_u24lambda_u243 = builder = this;
            boolean bl = false;
            $this$claims_u24lambda_u243.claims.putAll(claims);
            return builder;
        }

        @NotNull
        public final Builder addClaim(@NotNull String key, @NotNull Object value) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$addClaim_u24lambda_u244 = builder = this;
            boolean bl = false;
            $this$addClaim_u24lambda_u244.claims.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder issuedAt(@NotNull ZonedDateTime iat) {
            Intrinsics.checkNotNullParameter((Object)iat, (String)"iat");
            return this.addClaim("iat", iat);
        }

        @NotNull
        public final Builder id(@NotNull String jti) {
            Intrinsics.checkNotNullParameter((Object)jti, (String)"jti");
            return this.addClaim("jti", jti);
        }

        @NotNull
        public final Builder notBefore(@NotNull ZonedDateTime nbf) {
            Intrinsics.checkNotNullParameter((Object)nbf, (String)"nbf");
            return this.addClaim("nbf", nbf);
        }

        @NotNull
        public final Builder expiresAt(@NotNull ZonedDateTime exp) {
            Intrinsics.checkNotNullParameter((Object)exp, (String)"exp");
            return this.addClaim("exp", exp);
        }

        @NotNull
        public final Builder subject(@NotNull String subject) {
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            return this.addClaim("sub", subject);
        }

        @NotNull
        public final Jwt build() {
            this.validate();
            return new Jwt(this.applicationId, this.privateKeyContents, this.claims, null);
        }

        private final void validate() {
            if (Intrinsics.areEqual((Object)this.applicationId, (Object)"") && Intrinsics.areEqual((Object)this.privateKeyContents, (Object)"")) {
                throw new IllegalStateException("Both an Application ID and Private Key are required.");
            }
            if (Intrinsics.areEqual((Object)this.applicationId, (Object)"")) {
                throw new IllegalStateException("Application ID is required.");
            }
            if (Intrinsics.areEqual((Object)this.privateKeyContents, (Object)"") && this.signed) {
                throw new IllegalStateException("Private Key is required for signed token.");
            }
        }

        public Builder() {
            this(null, null, false, null, 15, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0007\u00a8\u0006\n"}, d2={"Lcom/vonage/jwt/Jwt$Companion;", "", "()V", "builder", "Lcom/vonage/jwt/Jwt$Builder;", "verifySignature", "", "token", "", "secret", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder(null, null, false, null, 15, null);
        }

        @JvmStatic
        public final boolean verifySignature(@NotNull String token, @NotNull String secret) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
            try {
                String string = secret;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                SecretKeySpec secretSpec = new SecretKeySpec(byArray, "HmacSHA256");
                Jwts.parser().verifyWith((SecretKey)secretSpec).build().parse((CharSequence)token);
                bl = true;
            }
            catch (SignatureException ex) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

