/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.jwt;

import com.vonage.jwt.Jwt;
import com.vonage.jwt.KeyConverter;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u0006H\u0002J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vonage/jwt/JwtGenerator;", "", "keyConverter", "Lcom/vonage/jwt/KeyConverter;", "(Lcom/vonage/jwt/KeyConverter;)V", "fixClaims", "", "", "claims", "generate", "jwt", "Lcom/vonage/jwt/Jwt;"})
@SourceDebugExtension(value={"SMAP\nJwtGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JwtGenerator.kt\ncom/vonage/jwt/JwtGenerator\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n526#2:64\n511#2,6:65\n453#2:71\n403#2:72\n1238#3,4:73\n*S KotlinDebug\n*F\n+ 1 JwtGenerator.kt\ncom/vonage/jwt/JwtGenerator\n*L\n55#1:64\n55#1:65,6\n56#1:71\n56#1:72\n56#1:73,4\n*E\n"})
public final class JwtGenerator {
    @NotNull
    private final KeyConverter keyConverter;

    public JwtGenerator(@NotNull KeyConverter keyConverter) {
        Intrinsics.checkNotNullParameter((Object)keyConverter, (String)"keyConverter");
        this.keyConverter = keyConverter;
    }

    public /* synthetic */ JwtGenerator(KeyConverter keyConverter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            keyConverter = new KeyConverter(null, 1, null);
        }
        this(keyConverter);
    }

    @NotNull
    public final String generate(@NotNull Jwt jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        JwtBuilder jwtBuilder = (JwtBuilder)((JwtBuilder.BuilderClaims)((JwtBuilder.BuilderClaims)((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().add((Object)"type", (Object)"JWT")).and()).claims().add((Object)"application_id", (Object)jwt.getApplicationId())).add(this.fixClaims(jwt.getClaims()))).and();
        if (!StringsKt.isBlank((CharSequence)jwt.getPrivateKeyContents())) {
            RSAPrivateKey privateKey = this.keyConverter.privateKey(jwt.getPrivateKeyContents());
            jwtBuilder = jwtBuilder.signWith((Key)privateKey, (SecureDigestAlgorithm)Jwts.SIG.RS256);
        }
        String string = jwtBuilder.compact();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compact(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Object> fixClaims(Map<String, ? extends Object> claims) {
        void $this$mapValuesTo$iv$iv;
        void $this$mapValues$iv;
        void $this$filterTo$iv$iv;
        LinkedHashMap<String, Object> normalClaims = new LinkedHashMap<String, Object>();
        normalClaims.putAll(claims);
        Object[] objectArray = new String[]{"iat", "exp", "nbf"};
        List timeKeys = CollectionsKt.listOf((Object[])objectArray);
        Map $this$filter$iv = claims;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(timeKeys.contains(it.getKey()) && it.getValue() instanceof ZonedDateTime)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$filterTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type java.time.ZonedDateTime");
            Long l = ((ZonedDateTime)v).toEpochSecond();
            map3.put(k, l);
        }
        Map convertedClaims = destination$iv$iv;
        normalClaims.putAll(convertedClaims);
        normalClaims.putIfAbsent("iat", Instant.now().getEpochSecond());
        normalClaims.putIfAbsent("jti", UUID.randomUUID().toString());
        return normalClaims;
    }

    public JwtGenerator() {
        this(null, 1, null);
    }
}

