/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.jwt;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/vonage/jwt/KeyConverter;", "", "keyFactory", "Ljava/security/KeyFactory;", "(Ljava/security/KeyFactory;)V", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "key", "", "privateKeySpec", "Ljava/security/spec/PKCS8EncodedKeySpec;", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "publicKeySpec", "Ljava/security/spec/X509EncodedKeySpec;", "sanitize", "Companion", "jwt"})
public final class KeyConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KeyFactory keyFactory;
    @NotNull
    private static final String PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----\n";
    @NotNull
    private static final String PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    @NotNull
    private static final String PUBLIC_KEY_HEADER = "-----BEGIN PUBLIC KEY-----\n";
    @NotNull
    private static final String PUBLIC_KEY_FOOTER = "-----END PUBLIC KEY-----";

    public KeyConverter(@NotNull KeyFactory keyFactory) {
        Intrinsics.checkNotNullParameter((Object)keyFactory, (String)"keyFactory");
        this.keyFactory = keyFactory;
    }

    public /* synthetic */ KeyConverter(KeyFactory keyFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            KeyFactory keyFactory2 = KeyFactory.getInstance("RSA");
            Intrinsics.checkNotNullExpressionValue((Object)keyFactory2, (String)"getInstance(...)");
            keyFactory = keyFactory2;
        }
        this(keyFactory);
    }

    @NotNull
    public final RSAPrivateKey privateKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PrivateKey privateKey = this.keyFactory.generatePrivate(this.privateKeySpec(this.sanitize(key)));
        Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        return (RSAPrivateKey)privateKey;
    }

    @NotNull
    public final RSAPublicKey publicKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        PublicKey publicKey = this.keyFactory.generatePublic(this.publicKeySpec(this.sanitize(key)));
        Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.RSAPublicKey");
        return (RSAPublicKey)publicKey;
    }

    private final String sanitize(String key) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)key, (String)PRIVATE_KEY_HEADER, (String)"", (boolean)false, (int)4, null), (String)PRIVATE_KEY_FOOTER, (String)"", (boolean)false, (int)4, null), (String)PUBLIC_KEY_HEADER, (String)"", (boolean)false, (int)4, null), (String)PUBLIC_KEY_FOOTER, (String)"", (boolean)false, (int)4, null);
        Regex regex = new Regex("\\s");
        String string = "";
        return regex.replace(charSequence, string);
    }

    private final PKCS8EncodedKeySpec privateKeySpec(String key) {
        return new PKCS8EncodedKeySpec(Base64.getDecoder().decode(key));
    }

    private final X509EncodedKeySpec publicKeySpec(String key) {
        return new X509EncodedKeySpec(Base64.getDecoder().decode(key));
    }

    public KeyConverter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/vonage/jwt/KeyConverter$Companion;", "", "()V", "PRIVATE_KEY_FOOTER", "", "PRIVATE_KEY_HEADER", "PUBLIC_KEY_FOOTER", "PUBLIC_KEY_HEADER", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

