/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTCreator;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.vonage.jwt.KeyConverter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.interfaces.RSAKey;
import java.security.spec.InvalidKeySpecException;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class Jwt {
    static final String APPLICATION_ID_CLAIM = "application_id";
    private final String privateKeyContents;
    private final JWTCreator.Builder jwtBuilder;
    private final Algorithm algorithm;
    private final DecodedJWT jwt;

    private Jwt(Builder builder) {
        this.privateKeyContents = builder.privateKeyContents;
        this.jwtBuilder = builder.auth0JwtBuilder;
        this.jwt = JWT.decode((String)this.jwtBuilder.sign(Algorithm.none()));
        try {
            this.algorithm = this.privateKeyContents == null || this.privateKeyContents.trim().isEmpty() ? Algorithm.none() : Algorithm.RSA256((RSAKey)new KeyConverter().privateKey(this.privateKeyContents));
        }
        catch (InvalidKeySpecException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String generate() {
        Instant iat;
        String jti = this.getId();
        if (jti == null || jti.isEmpty()) {
            this.jwtBuilder.withJWTId(UUID.randomUUID().toString());
        }
        if ((iat = this.getIssuedAt()) == null) {
            this.jwtBuilder.withIssuedAt(Instant.now());
        }
        return this.jwtBuilder.sign(this.algorithm);
    }

    public UUID getApplicationId() {
        return UUID.fromString(this.jwt.getClaim(APPLICATION_ID_CLAIM).asString());
    }

    String getPrivateKeyContents() {
        return this.privateKeyContents;
    }

    public Map<String, ?> getClaims() {
        return this.jwt.getClaims().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((Claim)e.getValue()).as(Object.class)));
    }

    public String getId() {
        return this.jwt.getId();
    }

    public Instant getIssuedAt() {
        return this.jwt.getIssuedAtAsInstant();
    }

    public Instant getNotBefore() {
        return this.jwt.getNotBeforeAsInstant();
    }

    public Instant getExpiresAt() {
        return this.jwt.getExpiresAtAsInstant();
    }

    public String getSubject() {
        return this.jwt.getSubject();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static boolean verifySignature(String token, String secret) {
        try {
            Objects.requireNonNull(token, "Token cannot be null.");
            Objects.requireNonNull(secret, "Secret cannot be null.");
            JWT.require((Algorithm)Algorithm.HMAC256((String)secret)).build().verify(token);
            return true;
        }
        catch (JWTVerificationException ex) {
            return false;
        }
    }

    public static class Builder {
        private final JWTCreator.Builder auth0JwtBuilder = JWT.create();
        private UUID applicationId;
        private String privateKeyContents = "";
        private boolean signed = true;

        public Builder applicationId(UUID applicationId) {
            this.applicationId = Objects.requireNonNull(applicationId);
            return this.withProperties(b -> b.withClaim(Jwt.APPLICATION_ID_CLAIM, applicationId.toString()));
        }

        public Builder applicationId(String applicationId) {
            return this.applicationId(UUID.fromString(applicationId));
        }

        public Builder unsigned() {
            this.signed = false;
            return this;
        }

        public Builder privateKeyContents(String privateKeyContents) {
            this.privateKeyContents = Objects.requireNonNull(privateKeyContents);
            this.signed = !privateKeyContents.isEmpty();
            return this;
        }

        public Builder privateKeyPath(Path privateKeyPath) throws IOException {
            return this.privateKeyContents(new String(Files.readAllBytes(privateKeyPath)));
        }

        public Builder privateKeyPath(String privateKeyPath) throws IOException {
            return this.privateKeyPath(Paths.get(privateKeyPath, new String[0]));
        }

        public Builder withProperties(Consumer<JWTCreator.Builder> jwtBuilder) {
            jwtBuilder.accept(this.auth0JwtBuilder);
            return this;
        }

        public Builder claims(Map<String, ?> claims) {
            this.withProperties(b -> b.withPayload(claims));
            return this;
        }

        public Builder addClaim(String key, Object value) {
            return this.claims(Collections.singletonMap(key, value));
        }

        public Builder issuedAt(ZonedDateTime iat) {
            return this.withProperties(b -> b.withIssuedAt(iat.toInstant()));
        }

        public Builder id(String jti) {
            return this.withProperties(b -> b.withJWTId(jti));
        }

        public Builder notBefore(ZonedDateTime nbf) {
            return this.withProperties(b -> b.withNotBefore(nbf.toInstant()));
        }

        public Builder expiresAt(ZonedDateTime exp) {
            return this.withProperties(b -> b.withExpiresAt(exp.toInstant()));
        }

        public Builder subject(String sub) {
            return this.withProperties(b -> b.withSubject(sub));
        }

        public Jwt build() {
            this.validate();
            return new Jwt(this);
        }

        private void validate() {
            if (this.applicationId == null && this.privateKeyContents.isEmpty()) {
                throw new IllegalStateException("Both an Application ID and Private Key are required.");
            }
            if (this.applicationId == null) {
                throw new IllegalStateException("Application ID is required.");
            }
            if (this.privateKeyContents.trim().isEmpty() && this.signed) {
                throw new IllegalStateException("Private Key is required for signed token.");
            }
        }
    }
}

