/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.app.Activity;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.util.SizeF;
import android.view.Surface;
import androidx.camera.camera2.Camera2Config;
import androidx.camera.camera2.interop.Camera2Interop;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mediapipe.components.CameraHelper;
import com.google.mediapipe.glutil.EglManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.microedition.khronos.egl.EGLSurface;

public class CameraXPreviewHelper
extends CameraHelper
implements CameraXConfig.Provider {
    private static final String TAG = "CameraXPreviewHelper";
    private static final Size TARGET_SIZE = new Size(1280, 720);
    private static final double ASPECT_TOLERANCE = 0.25;
    private static final double ASPECT_PENALTY = 10000.0;
    private static final int CLOCK_OFFSET_CALIBRATION_ATTEMPTS = 3;
    private static final int TARGET_RATE_FPS = 30;
    private final SingleThreadHandlerExecutor renderExecutor = new SingleThreadHandlerExecutor("RenderThread", 0);
    private ProcessCameraProvider cameraProvider;
    private Preview preview;
    private ImageCapture imageCapture;
    private ImageCapture.Builder imageCaptureBuilder;
    private ExecutorService imageCaptureExecutorService;
    private Camera camera;
    private int[] textures = null;
    private Size frameSize;
    private int frameRotation;
    private boolean isImageCaptureEnabled = false;
    @Nullable
    private CameraCharacteristics cameraCharacteristics = null;
    private float focalLengthPixels = Float.MIN_VALUE;
    private int cameraTimestampSource = 0;
    private static final List<String> CONTROL_AE_MODELS = Arrays.asList("Pixel 6a");

    @Override
    public void startCamera(Activity activity, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture) {
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, surfaceTexture, TARGET_SIZE, 30);
    }

    public CameraXConfig getCameraXConfig() {
        CameraXConfig.Builder builder = CameraXConfig.Builder.fromConfig((CameraXConfig)Camera2Config.defaultConfig());
        builder = builder.setMinimumLoggingLevel(3);
        return builder.build();
    }

    public void startCamera(Activity activity, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture, @Nullable Size targetSize, int targetRateFPS) {
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, surfaceTexture, targetSize, targetRateFPS);
    }

    public void startCamera(Activity activity, @Nonnull ImageCapture.Builder imageCaptureBuilder, CameraHelper.CameraFacing cameraFacing, @Nullable Size targetSize, int targetRateFPS) {
        this.imageCaptureBuilder = imageCaptureBuilder;
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, targetSize, targetRateFPS);
    }

    public void startCamera(Activity activity, @Nonnull ImageCapture.Builder imageCaptureBuilder, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture, @Nullable Size targetSize, int targetRateFPS) {
        this.imageCaptureBuilder = imageCaptureBuilder;
        this.startCamera((Context)activity, (LifecycleOwner)activity, cameraFacing, surfaceTexture, targetSize, targetRateFPS);
    }

    public void startCamera(Context context, LifecycleOwner lifecycleOwner, CameraHelper.CameraFacing cameraFacing, @Nullable Size targetSize, int targetRateFPS) {
        this.startCamera(context, lifecycleOwner, cameraFacing, null, targetSize, targetRateFPS);
    }

    private void startCamera(Context context, LifecycleOwner lifecycleOwner, CameraHelper.CameraFacing cameraFacing, @Nullable SurfaceTexture surfaceTexture, @Nullable Size targetSize, int targetRateFPS) {
        Executor mainThreadExecutor = ContextCompat.getMainExecutor((Context)context);
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)context);
        boolean isSurfaceTextureProvided = surfaceTexture != null;
        Integer selectedLensFacing = cameraFacing == CameraHelper.CameraFacing.FRONT ? 0 : 1;
        this.cameraCharacteristics = CameraXPreviewHelper.getCameraCharacteristics(context, selectedLensFacing);
        if ((targetSize = this.getOptimalViewSize(targetSize)) == null) {
            targetSize = TARGET_SIZE;
        }
        Range<Integer> optimalTargetRateFPS = this.getOptimalTargetRateFPS(targetRateFPS);
        Size rotatedSize = new Size(targetSize.getHeight(), targetSize.getWidth());
        cameraProviderFuture.addListener(() -> {
            try {
                this.cameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                Log.e((String)TAG, (String)"Unable to get ProcessCameraProvider: ", (Throwable)e);
                return;
            }
            Preview.Builder previewBuilder = new Preview.Builder();
            previewBuilder = previewBuilder.setTargetResolution(rotatedSize);
            Camera2Interop.Extender previewBuilderExtender = new Camera2Interop.Extender((ExtendableBuilder)previewBuilder);
            previewBuilderExtender.setCaptureRequestOption(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)optimalTargetRateFPS);
            if (this.maybeDisableAutoExposure()) {
                Log.d((String)TAG, (String)"Disable auto-exposure");
                previewBuilderExtender.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, (Object)0);
            }
            this.preview = previewBuilder.build();
            ImageAnalysis.Builder imageAnalysisBuilder = new ImageAnalysis.Builder();
            Camera2Interop.Extender imageAnalysisBuilderExtender = new Camera2Interop.Extender((ExtendableBuilder)imageAnalysisBuilder);
            imageAnalysisBuilderExtender.setCaptureRequestOption(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)optimalTargetRateFPS);
            if (this.maybeDisableAutoExposure()) {
                Log.d((String)TAG, (String)"Disable auto-exposure");
                imageAnalysisBuilderExtender.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, (Object)0);
            }
            ImageAnalysis imageAnalysis = imageAnalysisBuilder.build();
            CameraSelector cameraSelector = cameraFacing == CameraHelper.CameraFacing.FRONT ? CameraSelector.DEFAULT_FRONT_CAMERA : CameraSelector.DEFAULT_BACK_CAMERA;
            this.preview.setSurfaceProvider((Executor)this.renderExecutor, request -> {
                this.frameSize = request.getResolution();
                Log.d((String)TAG, (String)String.format("Received surface request for resolution %dx%d", this.frameSize.getWidth(), this.frameSize.getHeight()));
                SurfaceTexture previewFrameTexture = isSurfaceTextureProvided ? surfaceTexture : this.createSurfaceTexture();
                previewFrameTexture.setDefaultBufferSize(this.frameSize.getWidth(), this.frameSize.getHeight());
                request.setTransformationInfoListener((Executor)this.renderExecutor, transformationInfo -> {
                    CameraHelper.OnCameraStartedListener listener;
                    this.frameRotation = transformationInfo.getRotationDegrees();
                    this.updateCameraCharacteristics();
                    if (!isSurfaceTextureProvided) {
                        previewFrameTexture.detachFromGLContext();
                    }
                    if ((listener = this.onCameraStartedListener) != null) {
                        ContextCompat.getMainExecutor((Context)context).execute(() -> listener.onCameraStarted(previewFrameTexture));
                    }
                });
                Surface surface = new Surface(previewFrameTexture);
                Log.d((String)TAG, (String)"Providing surface");
                request.provideSurface(surface, (Executor)this.renderExecutor, result -> {
                    Log.d((String)TAG, (String)("Surface request result: " + result));
                    if (this.textures != null) {
                        GLES20.glDeleteTextures((int)1, (int[])this.textures, (int)0);
                    }
                    if (!isSurfaceTextureProvided) {
                        previewFrameTexture.release();
                    }
                    surface.release();
                });
            });
            this.cameraProvider.unbindAll();
            if (this.imageCaptureBuilder != null) {
                this.imageCapture = this.imageCaptureBuilder.build();
                this.camera = this.cameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, new UseCase[]{this.preview, imageAnalysis, this.imageCapture});
                this.imageCaptureExecutorService = Executors.newSingleThreadExecutor();
                this.isImageCaptureEnabled = true;
            } else {
                this.camera = this.cameraProvider.bindToLifecycle(lifecycleOwner, cameraSelector, new UseCase[]{this.preview, imageAnalysis});
            }
        }, mainThreadExecutor);
    }

    @Override
    public void stopCamera() {
        if (this.cameraProvider == null) {
            return;
        }
        this.cameraProvider.unbindAll();
    }

    public void takePicture(File outputFile, ImageCapture.OnImageSavedCallback onImageSavedCallback) {
        if (this.isImageCaptureEnabled) {
            ImageCapture.OutputFileOptions outputFileOptions = new ImageCapture.OutputFileOptions.Builder(outputFile).build();
            this.imageCapture.takePicture(outputFileOptions, (Executor)this.imageCaptureExecutorService, onImageSavedCallback);
        }
    }

    @Override
    public boolean isCameraRotated() {
        return this.frameRotation % 180 == 90;
    }

    @Override
    public Size computeDisplaySizeFromViewSize(Size viewSize) {
        return this.frameSize;
    }

    @Nullable
    private Size getOptimalViewSize(@Nullable Size targetSize) {
        if (targetSize == null || this.cameraCharacteristics == null) {
            return null;
        }
        StreamConfigurationMap map = (StreamConfigurationMap)this.cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] outputSizes = map.getOutputSizes(SurfaceTexture.class);
        Size optimalSize = null;
        double targetRatio = (double)targetSize.getWidth() / (double)targetSize.getHeight();
        Log.d((String)TAG, (String)String.format("Camera target size ratio: %f width: %d", targetRatio, targetSize.getWidth()));
        double minCost = Double.MAX_VALUE;
        for (Size size : outputSizes) {
            double aspectRatio = (double)size.getWidth() / (double)size.getHeight();
            double ratioDiff = Math.abs(aspectRatio - targetRatio);
            double cost = (ratioDiff > 0.25 ? 10000.0 + ratioDiff * (double)targetSize.getHeight() : 0.0) + (double)Math.abs(size.getWidth() - targetSize.getWidth());
            Log.d((String)TAG, (String)String.format("Camera size candidate width: %d height: %d ratio: %f cost: %f", size.getWidth(), size.getHeight(), aspectRatio, cost));
            if (!(cost < minCost)) continue;
            optimalSize = size;
            minCost = cost;
        }
        if (optimalSize != null) {
            Log.d((String)TAG, (String)String.format("Optimal camera size width: %d height: %d", optimalSize.getWidth(), optimalSize.getHeight()));
        }
        return optimalSize;
    }

    public long getTimeOffsetToMonoClockNanos() {
        if (this.cameraTimestampSource == 1) {
            return CameraXPreviewHelper.getOffsetFromRealtimeTimestampSource();
        }
        return CameraXPreviewHelper.getOffsetFromUnknownTimestampSource();
    }

    private static long getOffsetFromUnknownTimestampSource() {
        return 0L;
    }

    private static long getOffsetFromRealtimeTimestampSource() {
        long offset = Long.MAX_VALUE;
        long lowestGap = Long.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            long startMonoTs = System.nanoTime();
            long realTs = SystemClock.elapsedRealtimeNanos();
            long endMonoTs = System.nanoTime();
            long gapMonoTs = endMonoTs - startMonoTs;
            if (gapMonoTs >= lowestGap) continue;
            lowestGap = gapMonoTs;
            offset = (startMonoTs + endMonoTs) / 2L - realTs;
        }
        return offset;
    }

    public float getFocalLengthPixels() {
        return this.focalLengthPixels;
    }

    public Size getFrameSize() {
        return this.frameSize;
    }

    private void updateCameraCharacteristics() {
        if (this.cameraCharacteristics != null) {
            this.cameraTimestampSource = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_TIMESTAMP_SOURCE);
            this.focalLengthPixels = this.calculateFocalLengthInPixels();
        }
    }

    private float calculateFocalLengthInPixels() {
        float focalLengthMm = ((float[])this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS))[0];
        float sensorWidthMm = ((SizeF)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE)).getWidth();
        return (float)this.frameSize.getWidth() * focalLengthMm / sensorWidthMm;
    }

    private SurfaceTexture createSurfaceTexture() {
        EglManager eglManager = new EglManager(null);
        EGLSurface tempEglSurface = eglManager.createOffscreenSurface(1, 1);
        eglManager.makeCurrent(tempEglSurface, tempEglSurface);
        this.textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])this.textures, (int)0);
        SurfaceTexture previewFrameTexture = new SurfaceTexture(this.textures[0]);
        return previewFrameTexture;
    }

    @Nullable
    private static CameraCharacteristics getCameraCharacteristics(Context context, Integer lensFacing) {
        CameraManager cameraManager = (CameraManager)context.getSystemService("camera");
        try {
            List<String> cameraList = Arrays.asList(cameraManager.getCameraIdList());
            for (String availableCameraId : cameraList) {
                CameraCharacteristics availableCameraCharacteristics = cameraManager.getCameraCharacteristics(availableCameraId);
                Integer availableLensFacing = (Integer)availableCameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
                if (availableLensFacing == null || !availableLensFacing.equals(lensFacing)) continue;
                return availableCameraCharacteristics;
            }
        }
        catch (CameraAccessException e) {
            Log.e((String)TAG, (String)("Accessing camera ID info got error: " + (Object)((Object)e)));
        }
        return null;
    }

    private FramerateRange getClosestSupportedFramerateRange(List<FramerateRange> supportedFramerates, final int requestedFps) {
        return Collections.min(supportedFramerates, new ClosestComparator<FramerateRange>(){
            private static final int MAX_FPS_DIFF_THRESHOLD = 5000;
            private static final int MAX_FPS_LOW_DIFF_WEIGHT = 1;
            private static final int MAX_FPS_HIGH_DIFF_WEIGHT = 3;
            private static final int MIN_FPS_THRESHOLD = 8000;
            private static final int MIN_FPS_LOW_VALUE_WEIGHT = 1;
            private static final int MIN_FPS_HIGH_VALUE_WEIGHT = 4;

            private int progressivePenalty(int value, int threshold, int lowWeight, int highWeight) {
                return value < threshold ? value * lowWeight : threshold * lowWeight + (value - threshold) * highWeight;
            }

            @Override
            int diff(FramerateRange range) {
                int minFpsError = this.progressivePenalty(range.min, 8000, 1, 4);
                int maxFpsError = this.progressivePenalty(Math.abs(requestedFps * 1000 - range.max), 5000, 1, 3);
                return minFpsError + maxFpsError;
            }
        });
    }

    private int getFpsUnitFactor(Range<Integer>[] fpsRanges) {
        if (fpsRanges.length == 0) {
            return 1000;
        }
        return (Integer)fpsRanges[0].getUpper() < 1000 ? 1000 : 1;
    }

    private List<FramerateRange> convertFramerates(Range<Integer>[] arrayRanges, int unitFactor) {
        ArrayList<FramerateRange> ranges = new ArrayList<FramerateRange>();
        for (Range<Integer> range : arrayRanges) {
            ranges.add(new FramerateRange((Integer)range.getLower() * unitFactor, (Integer)range.getUpper() * unitFactor));
        }
        return ranges;
    }

    private Range<Integer> getOptimalTargetRateFPS(int targetRateFPS) {
        Object[] availableFpsRange = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        Log.d((String)TAG, (String)("Available FPS Ranges: " + Arrays.toString(availableFpsRange)));
        int fpsUnitFactor = this.getFpsUnitFactor((Range<Integer>[])availableFpsRange);
        List<FramerateRange> framerateRanges = this.convertFramerates((Range<Integer>[])availableFpsRange, fpsUnitFactor);
        FramerateRange bestFpsRange = this.getClosestSupportedFramerateRange(framerateRanges, targetRateFPS);
        Log.d((String)TAG, (String)("Best FPS Range: " + bestFpsRange.toString()));
        return new Range((Comparable)Integer.valueOf(bestFpsRange.min), (Comparable)Integer.valueOf(bestFpsRange.max));
    }

    private boolean maybeDisableAutoExposure() {
        int[] controlAEAvailableModes = (int[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_MODES);
        Log.d((String)TAG, (String)("CONTROL_AE_AVAILABLE_MODES: " + Arrays.toString(controlAEAvailableModes)));
        return CONTROL_AE_MODELS.contains(Build.MODEL) && Arrays.stream(controlAEAvailableModes).anyMatch(n -> n == 0);
    }

    private static final class SingleThreadHandlerExecutor
    implements Executor {
        private final HandlerThread handlerThread;
        private final Handler handler;

        SingleThreadHandlerExecutor(String threadName, int priority) {
            this.handlerThread = new HandlerThread(threadName, priority);
            this.handlerThread.start();
            this.handler = new Handler(this.handlerThread.getLooper());
        }

        @Override
        public void execute(Runnable command) {
            if (!this.handler.post(command)) {
                throw new RejectedExecutionException(this.handlerThread.getName() + " is shutting down.");
            }
        }

        boolean shutdown() {
            return this.handlerThread.quitSafely();
        }
    }

    private static abstract class ClosestComparator<T>
    implements Comparator<T> {
        private ClosestComparator() {
        }

        abstract int diff(T var1);

        @Override
        public int compare(T t1, T t2) {
            return this.diff(t1) - this.diff(t2);
        }
    }

    private static final class FramerateRange {
        public int min;
        public int max;

        public FramerateRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return "[" + (float)this.min / 1000.0f + ":" + (float)this.max / 1000.0f + "]";
        }

        public boolean equals(Object other) {
            if (!(other instanceof FramerateRange)) {
                return false;
            }
            FramerateRange otherFramerate = (FramerateRange)other;
            return this.min == otherFramerate.min && this.max == otherFramerate.max;
        }

        public int hashCode() {
            return 1 + 65537 * this.min + this.max;
        }
    }
}

