/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.content.Context;
import android.graphics.Bitmap;
import android.media.AudioFormat;
import android.os.Handler;
import android.util.Log;
import com.google.common.base.Preconditions;
import com.google.mediapipe.components.AudioDataConsumer;
import com.google.mediapipe.components.AudioDataProcessor;
import com.google.mediapipe.components.TextureFrameConsumer;
import com.google.mediapipe.components.TextureFrameProcessor;
import com.google.mediapipe.framework.AndroidAssetUtil;
import com.google.mediapipe.framework.AndroidPacketCreator;
import com.google.mediapipe.framework.Graph;
import com.google.mediapipe.framework.GraphService;
import com.google.mediapipe.framework.GraphTextureFrame;
import com.google.mediapipe.framework.MediaPipeException;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.PacketCallback;
import com.google.mediapipe.framework.PacketGetter;
import com.google.mediapipe.framework.SurfaceOutput;
import com.google.mediapipe.framework.TextureFrame;
import com.google.mediapipe.proto.CalculatorProto;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;

public class FrameProcessor
implements TextureFrameProcessor,
AudioDataProcessor {
    private static final String TAG = "FrameProcessor";
    private static final int BYTES_PER_MONO_SAMPLE = 2;
    private static final int AUDIO_ENCODING = 2;
    private List<TextureFrameConsumer> videoConsumers = new ArrayList<TextureFrameConsumer>();
    private List<AudioDataConsumer> audioConsumers = new ArrayList<AudioDataConsumer>();
    private Graph mediapipeGraph;
    private AndroidPacketCreator packetCreator;
    private OnWillAddFrameListener addFrameListener;
    private ErrorListener asyncErrorListener;
    private String videoInputStream;
    private String videoInputStreamCpu;
    private String videoOutputStream;
    private SurfaceOutput videoSurfaceOutput;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private String audioInputStream;
    private String audioOutputStream;
    private int numAudioChannels = 1;
    private double audioSampleRate;
    private boolean useImage = false;

    public FrameProcessor(Context context, long parentNativeContext, String graphName, String inputStream, @Nullable String outputStream) {
        try {
            this.initializeGraphAndPacketCreator(context, graphName);
            this.addVideoStreams(parentNativeContext, inputStream, outputStream);
        }
        catch (MediaPipeException e) {
            Log.e((String)TAG, (String)"MediaPipe error: ", (Throwable)e);
        }
    }

    public FrameProcessor(String graph, Context context, long parentNativeContext, String inputStream, @Nullable String outputStream) {
        try {
            this.initializeTxtGraphAndPacketCreator(context, graph);
            this.addVideoStreams(parentNativeContext, inputStream, outputStream);
        }
        catch (MediaPipeException e) {
            Log.e((String)TAG, (String)"MediaPipe error: ", (Throwable)e);
        }
    }

    public FrameProcessor(Context context, String graphName) {
        this.initializeGraphAndPacketCreator(context, graphName);
    }

    public FrameProcessor(CalculatorProto.CalculatorGraphConfig graphConfig) {
        this.initializeGraphAndPacketCreator(graphConfig);
    }

    public void setUseImage(boolean use) {
        this.useImage = use;
    }

    private void initializeGraphAndPacketCreator(Context context, String graphName) {
        this.mediapipeGraph = new Graph();
        if (new File(graphName).isAbsolute()) {
            this.mediapipeGraph.loadBinaryGraph(graphName);
        } else {
            this.mediapipeGraph.loadBinaryGraph(AndroidAssetUtil.getAssetBytes(context.getAssets(), graphName));
        }
        this.packetCreator = new AndroidPacketCreator(this.mediapipeGraph);
    }

    private void initializeTxtGraphAndPacketCreator(Context context, String graph) {
        this.mediapipeGraph = new Graph();
        this.mediapipeGraph.loadTextGraph(graph);
        this.packetCreator = new AndroidPacketCreator(this.mediapipeGraph);
    }

    private void initializeGraphAndPacketCreator(CalculatorProto.CalculatorGraphConfig graphConfig) {
        this.mediapipeGraph = new Graph();
        this.mediapipeGraph.loadBinaryGraph(graphConfig);
        this.packetCreator = new AndroidPacketCreator(this.mediapipeGraph);
    }

    public void setAsynchronousErrorListener(@Nullable ErrorListener listener) {
        this.asyncErrorListener = listener;
    }

    public void setAsynchronousErrorListener(@Nullable ErrorListener listener, @Nullable Handler handler) {
        this.setAsynchronousErrorListener(handler == null ? listener : e -> handler.post(() -> listener.onError(e)));
    }

    public void addVideoStreams(long parentNativeContext, @Nullable String inputStream, @Nullable String outputStream) {
        this.videoInputStream = inputStream;
        this.videoOutputStream = outputStream;
        this.mediapipeGraph.setParentGlContext(parentNativeContext);
        if (this.videoOutputStream != null) {
            this.mediapipeGraph.addPacketCallback(this.videoOutputStream, new PacketCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(Packet packet) {
                    List currentConsumers;
                    1 var3_2 = this;
                    synchronized (var3_2) {
                        currentConsumers = FrameProcessor.this.videoConsumers;
                    }
                    for (TextureFrameConsumer consumer : currentConsumers) {
                        GraphTextureFrame frame = PacketGetter.getTextureFrame(packet);
                        if (Log.isLoggable((String)FrameProcessor.TAG, (int)2)) {
                            Log.v((String)FrameProcessor.TAG, (String)String.format("Output tex: %d width: %d height: %d to consumer %h", frame.getTextureName(), frame.getWidth(), frame.getHeight(), consumer));
                        }
                        consumer.onNewFrame(frame);
                    }
                }
            });
            this.videoSurfaceOutput = this.mediapipeGraph.addSurfaceOutput(this.videoOutputStream);
        }
    }

    public void addAudioStreams(@Nullable String inputStream, @Nullable String outputStream, int numInputChannels, int numOutputChannels, double audioSampleRateInHz) {
        this.audioInputStream = inputStream;
        this.audioOutputStream = outputStream;
        this.numAudioChannels = numInputChannels;
        this.audioSampleRate = audioSampleRateInHz;
        if (this.audioInputStream != null) {
            Packet audioHeader = this.packetCreator.createTimeSeriesHeader(this.numAudioChannels, this.audioSampleRate);
            this.mediapipeGraph.setStreamHeader(this.audioInputStream, audioHeader);
        }
        if (this.audioOutputStream != null) {
            int outputAudioChannelMask = numOutputChannels == 2 ? 12 : 16;
            final AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(2).setSampleRate((int)this.audioSampleRate).setChannelMask(outputAudioChannelMask).build();
            this.mediapipeGraph.addPacketCallback(this.audioOutputStream, new PacketCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(Packet packet) {
                    List currentAudioConsumers;
                    2 var3_2 = this;
                    synchronized (var3_2) {
                        currentAudioConsumers = FrameProcessor.this.audioConsumers;
                    }
                    for (AudioDataConsumer consumer : currentAudioConsumers) {
                        byte[] buffer = PacketGetter.getAudioByteData(packet);
                        ByteBuffer audioData = ByteBuffer.wrap(buffer);
                        consumer.onNewAudioData(audioData, packet.getTimestamp(), audioFormat);
                    }
                }
            });
        }
    }

    public synchronized <T> void setServiceObject(GraphService<T> service, T object) {
        this.mediapipeGraph.setServiceObject(service, object);
    }

    public void setInputSidePackets(Map<String, Packet> inputSidePackets) {
        Preconditions.checkState((!this.started.get() ? 1 : 0) != 0, (Object)"setInputSidePackets must be called before the graph is started");
        this.mediapipeGraph.setInputSidePackets(inputSidePackets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConsumer(TextureFrameConsumer consumer) {
        FrameProcessor frameProcessor = this;
        synchronized (frameProcessor) {
            this.videoConsumers = Arrays.asList(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioConsumer(AudioDataConsumer consumer) {
        FrameProcessor frameProcessor = this;
        synchronized (frameProcessor) {
            this.audioConsumers = Arrays.asList(consumer);
        }
    }

    public void setVideoInputStreamCpu(String inputStream) {
        this.videoInputStreamCpu = inputStream;
    }

    public void addPacketCallback(String outputStream, PacketCallback callback) {
        this.mediapipeGraph.addPacketCallback(outputStream, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(TextureFrameConsumer consumer) {
        FrameProcessor frameProcessor = this;
        synchronized (frameProcessor) {
            ArrayList<TextureFrameConsumer> newConsumers = new ArrayList<TextureFrameConsumer>(this.videoConsumers);
            newConsumers.add(consumer);
            this.videoConsumers = newConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeConsumer(TextureFrameConsumer listener) {
        boolean existed;
        FrameProcessor frameProcessor = this;
        synchronized (frameProcessor) {
            ArrayList<TextureFrameConsumer> newConsumers = new ArrayList<TextureFrameConsumer>(this.videoConsumers);
            existed = newConsumers.remove(listener);
            this.videoConsumers = newConsumers;
        }
        return existed;
    }

    public Graph getGraph() {
        return this.mediapipeGraph;
    }

    public AndroidPacketCreator getPacketCreator() {
        return this.packetCreator;
    }

    public SurfaceOutput getVideoSurfaceOutput() {
        return this.videoSurfaceOutput;
    }

    public void close() {
        if (this.started.get()) {
            try {
                this.mediapipeGraph.closeAllPacketSources();
                this.mediapipeGraph.waitUntilGraphDone();
            }
            catch (MediaPipeException e) {
                if (this.asyncErrorListener != null) {
                    this.asyncErrorListener.onError(e);
                }
                Log.e((String)TAG, (String)"Mediapipe error: ", (Throwable)e);
            }
            try {
                this.mediapipeGraph.tearDown();
            }
            catch (MediaPipeException e) {
                Log.e((String)TAG, (String)"Mediapipe error: ", (Throwable)e);
            }
        }
    }

    public void preheat() {
        if (!this.started.getAndSet(true)) {
            this.startGraph();
        }
    }

    public void setOnWillAddFrameListener(@Nullable OnWillAddFrameListener addFrameListener) {
        this.addFrameListener = addFrameListener;
    }

    private boolean maybeAcceptNewFrame(long timestamp) {
        if (!this.started.getAndSet(true)) {
            this.startGraph();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewFrame(TextureFrame frame) {
        block15: {
            Packet imagePacket = null;
            long timestamp = frame.getTimestamp();
            try {
                if (Log.isLoggable((String)TAG, (int)2)) {
                    Log.v((String)TAG, (String)String.format("Input tex: %d width: %d height: %d", frame.getTextureName(), frame.getWidth(), frame.getHeight()));
                }
                if (!this.maybeAcceptNewFrame(frame.getTimestamp())) {
                    return;
                }
                if (this.addFrameListener != null) {
                    this.addFrameListener.onWillAddFrame(timestamp);
                }
                imagePacket = this.useImage ? this.packetCreator.createImage(frame) : this.packetCreator.createGpuBuffer(frame);
                frame = null;
                try {
                    this.mediapipeGraph.addConsumablePacketToInputStream(this.videoInputStream, imagePacket, timestamp);
                    imagePacket = null;
                }
                catch (MediaPipeException e) {
                    if (this.asyncErrorListener == null) {
                        Log.e((String)TAG, (String)"Mediapipe error: ", (Throwable)e);
                        break block15;
                    }
                    throw e;
                }
            }
            catch (RuntimeException e) {
                if (this.asyncErrorListener != null) {
                    this.asyncErrorListener.onError(e);
                    break block15;
                }
                throw e;
            }
            finally {
                if (imagePacket != null) {
                    imagePacket.release();
                }
                if (frame != null) {
                    frame.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewFrame(Bitmap bitmap, long timestamp) {
        block13: {
            Packet packet = null;
            try {
                if (!this.maybeAcceptNewFrame(timestamp)) {
                    return;
                }
                if (this.addFrameListener != null) {
                    this.addFrameListener.onWillAddFrame(timestamp);
                }
                packet = this.getPacketCreator().createRgbImageFrame(bitmap);
                try {
                    this.mediapipeGraph.addConsumablePacketToInputStream(this.videoInputStreamCpu, packet, timestamp);
                    packet = null;
                }
                catch (MediaPipeException e) {
                    if (this.asyncErrorListener == null) {
                        Log.e((String)TAG, (String)"Mediapipe error: ", (Throwable)e);
                        break block13;
                    }
                    throw e;
                }
            }
            catch (RuntimeException e) {
                if (this.asyncErrorListener != null) {
                    this.asyncErrorListener.onError(e);
                    break block13;
                }
                throw e;
            }
            finally {
                if (packet != null) {
                    packet.release();
                }
            }
        }
    }

    public void waitUntilIdle() {
        try {
            this.mediapipeGraph.waitUntilGraphIdle();
        }
        catch (MediaPipeException e) {
            if (this.asyncErrorListener != null) {
                this.asyncErrorListener.onError(e);
            }
            Log.e((String)TAG, (String)"Mediapipe error: ", (Throwable)e);
        }
    }

    private void startGraph() {
        this.mediapipeGraph.startRunningGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNewAudioData(ByteBuffer audioData, long timestampMicros, AudioFormat audioFormat) {
        block13: {
            Packet audioPacket = null;
            try {
                if (!this.started.getAndSet(true)) {
                    this.startGraph();
                }
                if (audioFormat.getChannelCount() != this.numAudioChannels || (double)audioFormat.getSampleRate() != this.audioSampleRate || audioFormat.getEncoding() != 2) {
                    Log.e((String)TAG, (String)"Producer's AudioFormat doesn't match FrameProcessor's AudioFormat");
                    return;
                }
                Preconditions.checkNotNull((Object)this.audioInputStream);
                int numSamples = audioData.limit() / 2 / this.numAudioChannels;
                audioPacket = this.packetCreator.createAudioPacket(audioData, this.numAudioChannels, numSamples);
                try {
                    this.mediapipeGraph.addConsumablePacketToInputStream(this.audioInputStream, audioPacket, timestampMicros);
                    audioPacket = null;
                }
                catch (MediaPipeException e) {
                    if (this.asyncErrorListener == null) {
                        Log.e((String)TAG, (String)"Mediapipe error: ", (Throwable)e);
                        break block13;
                    }
                    throw e;
                }
            }
            catch (RuntimeException e) {
                if (this.asyncErrorListener != null) {
                    this.asyncErrorListener.onError(e);
                    break block13;
                }
                throw e;
            }
            finally {
                if (audioPacket != null) {
                    audioPacket.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioConsumer(AudioDataConsumer consumer) {
        FrameProcessor frameProcessor = this;
        synchronized (frameProcessor) {
            ArrayList<AudioDataConsumer> newConsumers = new ArrayList<AudioDataConsumer>(this.audioConsumers);
            newConsumers.add(consumer);
            this.audioConsumers = newConsumers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAudioConsumer(AudioDataConsumer consumer) {
        boolean existed;
        FrameProcessor frameProcessor = this;
        synchronized (frameProcessor) {
            ArrayList<AudioDataConsumer> newConsumers = new ArrayList<AudioDataConsumer>(this.audioConsumers);
            existed = newConsumers.remove(consumer);
            this.audioConsumers = newConsumers;
        }
        return existed;
    }

    public static interface OnWillAddFrameListener {
        public void onWillAddFrame(long var1);
    }

    public static interface ErrorListener {
        public void onError(RuntimeException var1);
    }
}

