/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.components;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;

public class PermissionHelper {
    private static final String TAG = "PermissionHelper";
    private static final String AUDIO_PERMISSION = "android.permission.RECORD_AUDIO";
    private static final String CAMERA_PERMISSION = "android.permission.CAMERA";
    private static final String READ_EXTERNAL_STORAGE_PERMISSION = "android.permission.READ_EXTERNAL_STORAGE";
    private static final int REQUEST_CODE = 0;

    public static boolean permissionsGranted(Activity context, String[] permissions) {
        for (String permission2 : permissions) {
            int permissionStatus = ContextCompat.checkSelfPermission((Context)context, (String)permission2);
            if (permissionStatus == 0) continue;
            return false;
        }
        return true;
    }

    public static void checkAndRequestPermissions(Activity context, String[] permissions) {
        if (!PermissionHelper.permissionsGranted(context, permissions)) {
            ActivityCompat.requestPermissions((Activity)context, (String[])permissions, (int)0);
        }
    }

    public static boolean cameraPermissionsGranted(Activity context) {
        return PermissionHelper.permissionsGranted(context, new String[]{CAMERA_PERMISSION});
    }

    public static void checkAndRequestCameraPermissions(Activity context) {
        Log.d((String)TAG, (String)"checkAndRequestCameraPermissions");
        PermissionHelper.checkAndRequestPermissions(context, new String[]{CAMERA_PERMISSION});
    }

    public static boolean audioPermissionsGranted(Activity context) {
        return PermissionHelper.permissionsGranted(context, new String[]{AUDIO_PERMISSION});
    }

    public static void checkAndRequestAudioPermissions(Activity context) {
        Log.d((String)TAG, (String)"checkAndRequestAudioPermissions");
        PermissionHelper.checkAndRequestPermissions(context, new String[]{AUDIO_PERMISSION});
    }

    public static boolean readExternalStoragePermissionsGranted(Activity context) {
        if (Build.VERSION.SDK_INT < 16) {
            return true;
        }
        return PermissionHelper.permissionsGranted(context, new String[]{READ_EXTERNAL_STORAGE_PERMISSION});
    }

    public static void checkAndRequestReadExternalStoragePermissions(Activity context) {
        if (Build.VERSION.SDK_INT >= 16) {
            Log.d((String)TAG, (String)"checkAndRequestReadExternalStoragePermissions");
            PermissionHelper.checkAndRequestPermissions(context, new String[]{READ_EXTERNAL_STORAGE_PERMISSION});
        }
    }

    public static void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        Log.d((String)TAG, (String)"onRequestPermissionsResult");
        if (permissions.length > 0 && grantResults.length != permissions.length) {
            Log.d((String)TAG, (String)"Permission denied.");
            return;
        }
        for (int i = 0; i < grantResults.length; ++i) {
            if (grantResults[i] != 0) continue;
            Log.d((String)TAG, (String)(permissions[i] + " permission granted."));
        }
    }
}

