/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.common.base.Preconditions;
import com.google.common.flogger.FluentLogger;
import com.google.mediapipe.framework.GraphTextureFrame;
import com.google.mediapipe.framework.Packet;
import com.google.mediapipe.framework.ProtoUtil;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class PacketGetter {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    public static Packet getPacketFromReference(Packet referencePacket) {
        return Packet.create(PacketGetter.nativeGetPacketFromReference(referencePacket.getNativeHandle()));
    }

    public static PacketPair getPairOfPackets(Packet packet) {
        long[] handles = PacketGetter.nativeGetPairPackets(packet.getNativeHandle());
        return new PacketPair(Packet.create(handles[0]), Packet.create(handles[1]));
    }

    public static List<Packet> getVectorOfPackets(Packet packet) {
        long[] handles = PacketGetter.nativeGetVectorPackets(packet.getNativeHandle());
        ArrayList<Packet> packets = new ArrayList<Packet>(handles.length);
        for (long handle : handles) {
            packets.add(Packet.create(handle));
        }
        return packets;
    }

    public static short getInt16(Packet packet) {
        return PacketGetter.nativeGetInt16(packet.getNativeHandle());
    }

    public static int getInt32(Packet packet) {
        return PacketGetter.nativeGetInt32(packet.getNativeHandle());
    }

    public static long getInt64(Packet packet) {
        return PacketGetter.nativeGetInt64(packet.getNativeHandle());
    }

    public static float getFloat32(Packet packet) {
        return PacketGetter.nativeGetFloat32(packet.getNativeHandle());
    }

    public static double getFloat64(Packet packet) {
        return PacketGetter.nativeGetFloat64(packet.getNativeHandle());
    }

    public static boolean getBool(Packet packet) {
        return PacketGetter.nativeGetBool(packet.getNativeHandle());
    }

    public static String getString(Packet packet) {
        return PacketGetter.nativeGetString(packet.getNativeHandle());
    }

    public static byte[] getBytes(Packet packet) {
        return PacketGetter.nativeGetBytes(packet.getNativeHandle());
    }

    public static byte[] getProtoBytes(Packet packet) {
        return PacketGetter.nativeGetProtoBytes(packet.getNativeHandle());
    }

    public static <T extends MessageLite> T getProto(Packet packet, T defaultInstance) throws InvalidProtocolBufferException {
        ProtoUtil.SerializedMessage result = new ProtoUtil.SerializedMessage();
        PacketGetter.nativeGetProto(packet.getNativeHandle(), result);
        return ProtoUtil.unpack(result, defaultInstance);
    }

    @Deprecated
    public static <T extends MessageLite> T getProto(Packet packet, Class<T> clazz) throws InvalidProtocolBufferException {
        return (T)PacketGetter.getProto(packet, Internal.getDefaultInstance(clazz));
    }

    public static short[] getInt16Vector(Packet packet) {
        return PacketGetter.nativeGetInt16Vector(packet.getNativeHandle());
    }

    public static int[] getInt32Vector(Packet packet) {
        return PacketGetter.nativeGetInt32Vector(packet.getNativeHandle());
    }

    public static long[] getInt64Vector(Packet packet) {
        return PacketGetter.nativeGetInt64Vector(packet.getNativeHandle());
    }

    public static float[] getFloat32Vector(Packet packet) {
        return PacketGetter.nativeGetFloat32Vector(packet.getNativeHandle());
    }

    public static double[] getFloat64Vector(Packet packet) {
        return PacketGetter.nativeGetFloat64Vector(packet.getNativeHandle());
    }

    public static <T> List<T> getProtoVector(Packet packet, Parser<T> messageParser) {
        byte[][] protoVector = PacketGetter.nativeGetProtoVector(packet.getNativeHandle());
        Preconditions.checkNotNull((Object)protoVector, (Object)"Vector of protocol buffer objects should not be null!");
        try {
            ArrayList<Object> parsedMessageList = new ArrayList<Object>();
            for (byte[] message : protoVector) {
                Object parsedMessage = messageParser.parseFrom(message);
                parsedMessageList.add(parsedMessage);
            }
            return parsedMessageList;
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T extends MessageLite> List<T> getProtoVector(Packet packet, T defaultInstance) {
        Parser parser = defaultInstance.getParserForType();
        return PacketGetter.getProtoVector(packet, parser);
    }

    public static int getImageWidth(Packet packet) {
        return PacketGetter.nativeGetImageWidth(packet.getNativeHandle());
    }

    public static int getImageHeight(Packet packet) {
        return PacketGetter.nativeGetImageHeight(packet.getNativeHandle());
    }

    public static boolean getImageData(Packet packet, ByteBuffer buffer) {
        return PacketGetter.nativeGetImageData(packet.getNativeHandle(), buffer);
    }

    public static boolean getRgbaFromRgb(Packet packet, ByteBuffer buffer) {
        return PacketGetter.nativeGetRgbaFromRgb(packet.getNativeHandle(), buffer);
    }

    public static byte[] getAudioByteData(Packet packet) {
        return PacketGetter.nativeGetAudioData(packet.getNativeHandle());
    }

    public static int getAudioDataNumChannels(Packet packet) {
        return PacketGetter.nativeGetMatrixRows(packet.getNativeHandle());
    }

    public static int getAudioDataNumSamples(Packet packet) {
        return PacketGetter.nativeGetMatrixCols(packet.getNativeHandle());
    }

    public static int getTimeSeriesHeaderNumChannels(Packet packet) {
        return PacketGetter.nativeGetTimeSeriesHeaderNumChannels(packet.getNativeHandle());
    }

    public static double getTimeSeriesHeaderSampleRate(Packet packet) {
        return PacketGetter.nativeGetTimeSeriesHeaderSampleRate(packet.getNativeHandle());
    }

    public static int getVideoHeaderWidth(Packet packet) {
        return PacketGetter.nativeGetVideoHeaderWidth(packet.getNativeHandle());
    }

    public static int getVideoHeaderHeight(Packet packet) {
        return PacketGetter.nativeGetVideoHeaderHeight(packet.getNativeHandle());
    }

    public static float[] getMatrixData(Packet packet) {
        return PacketGetter.nativeGetMatrixData(packet.getNativeHandle());
    }

    public static int getMatrixRows(Packet packet) {
        return PacketGetter.nativeGetMatrixRows(packet.getNativeHandle());
    }

    public static int getMatrixCols(Packet packet) {
        return PacketGetter.nativeGetMatrixCols(packet.getNativeHandle());
    }

    @Deprecated
    public static int getGpuBufferName(Packet packet) {
        return PacketGetter.nativeGetGpuBufferName(packet.getNativeHandle());
    }

    public static GraphTextureFrame getTextureFrame(Packet packet) {
        return new GraphTextureFrame(PacketGetter.nativeGetGpuBuffer(packet.getNativeHandle(), true), packet.getTimestamp());
    }

    public static GraphTextureFrame getTextureFrameDeferredSync(Packet packet) {
        return new GraphTextureFrame(PacketGetter.nativeGetGpuBuffer(packet.getNativeHandle(), false), packet.getTimestamp(), true);
    }

    private static native long nativeGetPacketFromReference(long var0);

    private static native long[] nativeGetPairPackets(long var0);

    private static native long[] nativeGetVectorPackets(long var0);

    private static native short nativeGetInt16(long var0);

    private static native int nativeGetInt32(long var0);

    private static native long nativeGetInt64(long var0);

    private static native float nativeGetFloat32(long var0);

    private static native double nativeGetFloat64(long var0);

    private static native boolean nativeGetBool(long var0);

    private static native String nativeGetString(long var0);

    private static native byte[] nativeGetBytes(long var0);

    private static native byte[] nativeGetProtoBytes(long var0);

    private static native void nativeGetProto(long var0, ProtoUtil.SerializedMessage var2);

    private static native short[] nativeGetInt16Vector(long var0);

    private static native int[] nativeGetInt32Vector(long var0);

    private static native long[] nativeGetInt64Vector(long var0);

    private static native float[] nativeGetFloat32Vector(long var0);

    private static native double[] nativeGetFloat64Vector(long var0);

    private static native byte[][] nativeGetProtoVector(long var0);

    private static native int nativeGetImageWidth(long var0);

    private static native int nativeGetImageHeight(long var0);

    private static native boolean nativeGetImageData(long var0, ByteBuffer var2);

    private static native boolean nativeGetRgbaFromRgb(long var0, ByteBuffer var2);

    private static native int nativeGetVideoHeaderWidth(long var0);

    private static native int nativeGetVideoHeaderHeight(long var0);

    private static native int nativeGetTimeSeriesHeaderNumChannels(long var0);

    private static native double nativeGetTimeSeriesHeaderSampleRate(long var0);

    private static native byte[] nativeGetAudioData(long var0);

    private static native float[] nativeGetMatrixData(long var0);

    private static native int nativeGetMatrixRows(long var0);

    private static native int nativeGetMatrixCols(long var0);

    private static native int nativeGetGpuBufferName(long var0);

    private static native long nativeGetGpuBuffer(long var0, boolean var2);

    private PacketGetter() {
    }

    public static class PacketPair {
        final Packet first;
        final Packet second;

        public PacketPair(Packet first, Packet second) {
            this.first = first;
            this.second = second;
        }
    }
}

