/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.glutil;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.google.common.flogger.FluentLogger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.Map;
import javax.annotation.Nullable;

public class ShaderUtil {
    private static final FluentLogger logger = FluentLogger.forEnclosingClass();

    public static int loadShader(int shaderType, String source) {
        int shader = GLES20.glCreateShader((int)shaderType);
        GLES20.glShaderSource((int)shader, (String)source);
        GLES20.glCompileShader((int)shader);
        int[] compiled = new int[1];
        GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
        if (compiled[0] == 0) {
            ((FluentLogger.Api)logger.atSevere()).log("Could not compile shader %d: %s", shaderType, (Object)GLES20.glGetShaderInfoLog((int)shader));
            GLES20.glDeleteShader((int)shader);
            shader = 0;
        }
        return shader;
    }

    public static int createProgram(String vertexSource, String fragmentSource, @Nullable Map<String, Integer> attributeLocations) {
        int vertexShader = ShaderUtil.loadShader(35633, vertexSource);
        if (vertexShader == 0) {
            return 0;
        }
        int fragmentShader = ShaderUtil.loadShader(35632, fragmentSource);
        if (fragmentShader == 0) {
            return 0;
        }
        int program = GLES20.glCreateProgram();
        if (program == 0) {
            ((FluentLogger.Api)logger.atSevere()).log("Could not create program");
        }
        GLES20.glAttachShader((int)program, (int)vertexShader);
        GLES20.glAttachShader((int)program, (int)fragmentShader);
        if (attributeLocations != null) {
            for (Map.Entry<String, Integer> entry : attributeLocations.entrySet()) {
                GLES20.glBindAttribLocation((int)program, (int)entry.getValue(), (String)entry.getKey());
            }
        }
        GLES20.glLinkProgram((int)program);
        int[] linkStatus = new int[1];
        GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
        if (linkStatus[0] != 1) {
            ((FluentLogger.Api)logger.atSevere()).log("Could not link program: %s", (Object)GLES20.glGetProgramInfoLog((int)program));
            GLES20.glDeleteProgram((int)program);
            program = 0;
        }
        return program;
    }

    public static int createRgbaTexture(int width, int height) {
        int[] textureName = new int[]{0};
        GLES20.glGenTextures((int)1, (int[])textureName, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureName[0]);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5121, null);
        ShaderUtil.checkGlError("glTexImage2D");
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        ShaderUtil.checkGlError("texture setup");
        return textureName[0];
    }

    public static int createRgbaTexture(Bitmap bitmap) {
        int[] textureName = new int[]{0};
        GLES20.glGenTextures((int)1, (int[])textureName, (int)0);
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureName[0]);
        GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
        ShaderUtil.checkGlError("texImage2D");
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        ShaderUtil.checkGlError("texture setup");
        return textureName[0];
    }

    public static FloatBuffer floatBuffer(float ... values) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(values.length * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        floatBuffer.put(values);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static void checkGlError(String msg) {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new RuntimeException(msg + ": GL error: 0x" + Integer.toHexString(error));
        }
    }
}

