/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.mltransformers;

import android.app.Activity;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Size;
import androidx.annotation.Nullable;
import com.google.mediapipe.components.CameraHelper;
import com.google.mediapipe.components.CameraXPreviewHelper;
import com.vonage.mltransformers.VideoCapturer;
import com.vonage.webrtc.EglBase;
import com.vonage.webrtc.SurfaceTextureHelper;
import com.vonage.webrtc.VideoFrame;
import com.vonage.webrtc.VideoSink;

public class CameraXVideoCapturer
extends VideoCapturer
implements CameraHelper.OnCameraStartedListener,
VideoSink {
    private static final String LOGTAG = CameraXVideoCapturer.class.getCanonicalName();
    private State state;
    private CameraXPreviewHelper cameraXPreviewHelper;
    private SurfaceTexture surfaceTexture;
    private EglBase.Context sharedContext;
    private SurfaceTextureHelper surfaceTextureHelper;

    public CameraXVideoCapturer(EglBase.Context sharedContext) {
        Log.d((String)LOGTAG, (String)"Ctor");
        this.sharedContext = sharedContext;
        this.cameraXPreviewHelper = new CameraXPreviewHelper();
        this.surfaceTextureHelper = SurfaceTextureHelper.create((String)LOGTAG, (EglBase.Context)this.sharedContext);
        this.surfaceTexture = this.surfaceTextureHelper.getSurfaceTexture();
        this.state = State.CREATED;
    }

    @Override
    public void startCamera(Activity context, VideoCapturer.CameraFacing cameraFacing, int width, int height, int fps) {
        Log.d((String)LOGTAG, (String)"startCamera");
        if (this.state == State.STARTED || this.state == State.DISPOSED) {
            Log.e((String)LOGTAG, (String)"Wrong current state (either started or disposed");
            return;
        }
        this.surfaceTextureHelper.setTextureSize(width, height);
        this.surfaceTextureHelper.startListening((VideoSink)this);
        CameraHelper.CameraFacing facing = cameraFacing == VideoCapturer.CameraFacing.FRONT ? CameraHelper.CameraFacing.FRONT : CameraHelper.CameraFacing.BACK;
        this.cameraXPreviewHelper.setOnCameraStartedListener((CameraHelper.OnCameraStartedListener)this);
        this.cameraXPreviewHelper.startCamera(context, facing, this.surfaceTexture, new Size(width, height), fps);
        this.state = State.STARTED;
    }

    @Override
    public void stopCamera() {
        Log.d((String)LOGTAG, (String)"stopCamera");
        if (this.state == State.CREATED || this.state == State.STOPPED || this.state == State.DISPOSED) {
            Log.e((String)LOGTAG, (String)"Wrong current state (either created or stopped or disposed");
            return;
        }
        this.surfaceTextureHelper.stopListening();
        if (this.videoCapturerListener == null) {
            return;
        }
        this.videoCapturerListener.onCameraStopped();
        this.cameraXPreviewHelper.stopCamera();
        this.state = State.STOPPED;
    }

    public void onCameraStarted(@Nullable SurfaceTexture surfaceTexture) {
        Log.d((String)LOGTAG, (String)"onCameraStarted");
        this.surfaceTexture = surfaceTexture;
        if (this.videoCapturerListener == null) {
            return;
        }
        this.videoCapturerListener.onCameraStarted();
    }

    public void onFrame(VideoFrame videoFrame) {
        if (this.videoCapturerListener == null) {
            return;
        }
        this.videoCapturerListener.onFrameCaptured(videoFrame);
    }

    public void dispose() {
        Log.d((String)LOGTAG, (String)"dispose");
        if (this.state == State.STARTED) {
            this.stopCamera();
        }
        if (this.state == State.DISPOSED) {
            Log.e((String)LOGTAG, (String)"Wrong current state (disposed");
            return;
        }
        this.surfaceTexture.release();
        this.surfaceTextureHelper.dispose();
        this.surfaceTexture = null;
        this.surfaceTextureHelper = null;
        this.cameraXPreviewHelper = null;
        this.state = State.DISPOSED;
    }

    private static enum State {
        CREATED,
        STARTED,
        STOPPED,
        DISPOSED;

    }
}

