/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.mltransformers;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.opengl.EGLContext;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import androidx.annotation.Nullable;
import com.google.mediapipe.components.ExternalTextureConverter;
import com.google.mediapipe.components.FrameProcessor;
import com.google.mediapipe.components.TextureFrameConsumer;
import com.google.mediapipe.framework.AndroidAssetUtil;
import com.google.mediapipe.glutil.EglManager;
import com.vonage.webrtc.CalledByNative;
import com.vonage.webrtc.ContextUtils;
import com.vonage.webrtc.EglBase;
import com.vonage.webrtc.EglBase14;
import com.vonage.webrtc.SurfaceTextureHelper;
import com.vonage.webrtc.VideoFrame;
import com.vonage.webrtc.YuvConverter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MediapipeVideoFrameProcessor {
    private static final String LOGTAG = MediapipeVideoFrameProcessor.class.getCanonicalName();
    private static final String INPUT_STREAM = "input_video";
    private static final String OUTPUT_STREAM = "output_video";
    private static final int NUM_BUFFERS = 2;
    private static final boolean FLIP_FRAMES_VERTICALLY = false;
    private static final Map<Integer, Integer> WEBRTC_MEDIAPIPE_ROTATION_MAP;
    private boolean initialized = false;
    private FrameProcessor frameProcessor;
    private ExternalTextureConverter converter;
    @Nullable
    private SurfaceTextureHelper videoSurfaceOutputSurfaceTextureHelper;
    @Nullable
    private SurfaceTextureHelper videoSurfaceInputSurfaceTextureHelper;
    @Nullable
    private EglBase14 eglBase;
    @Nullable
    private Surface inputSurface;
    @Nullable
    private Surface outputSurface;
    private int width = 0;
    private int height = 0;
    private int rotation = -1;
    private Callback callback;

    public MediapipeVideoFrameProcessor() {
        Log.d((String)LOGTAG, (String)"MediapipeVideoFrameProcessor()");
    }

    private static boolean isEmulator() {
        Log.i((String)LOGTAG, (String)("isEmulator() Build.BOARD: " + Build.BOARD));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.BRAND: " + Build.BRAND));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.DEVICE: " + Build.DEVICE));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.FINGERPRINT: " + Build.FINGERPRINT));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.HARDWARE: " + Build.HARDWARE));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.MANUFACTURER: " + Build.MANUFACTURER));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.MODEL: " + Build.MODEL));
        Log.i((String)LOGTAG, (String)("isEmulator() Build.PRODUCT: " + Build.PRODUCT));
        return Build.MANUFACTURER.equals("Google") && Build.BRAND.equals("google") && (Build.FINGERPRINT.startsWith("google/sdk_gphone_") && Build.FINGERPRINT.endsWith(":user/release-keys") && Build.PRODUCT.startsWith("sdk_gphone_") && Build.MODEL.startsWith("sdk_gphone_") || Build.FINGERPRINT.startsWith("google/sdk_gphone64_") && (Build.FINGERPRINT.endsWith(":user/release-keys") || Build.FINGERPRINT.endsWith(":userdebug/dev-keys")) && Build.PRODUCT.startsWith("sdk_gphone64_") && Build.MODEL.startsWith("sdk_gphone64_")) || Build.HARDWARE.equals("goldfish") || Build.HARDWARE.equals("vbox86") || Build.HARDWARE.equals("ranchu") || Build.FINGERPRINT.startsWith("generic") || Build.FINGERPRINT.startsWith("unknown") || Build.MODEL.contains("google_sdk") || Build.MODEL.contains("Emulator") || Build.MODEL.contains("Android SDK built for x86") || Build.MANUFACTURER.contains("Genymotion") || Build.HOST.startsWith("Build") || Build.BRAND.startsWith("generic") && Build.DEVICE.startsWith("generic") || Build.PRODUCT.equals("google_sdk");
    }

    @CalledByNative
    public boolean init(Callback c, String graph) {
        Log.d((String)LOGTAG, (String)"init()");
        if (MediapipeVideoFrameProcessor.isEmulator()) {
            Log.w((String)LOGTAG, (String)"init(): Running on emulator");
            return false;
        }
        Log.i((String)LOGTAG, (String)"init(): Running on device");
        if (this.initialized) {
            Log.w((String)LOGTAG, (String)"init(): Already initialized");
            return true;
        }
        this.callback = c;
        Context context = ContextUtils.getApplicationContext();
        AndroidAssetUtil.initializeNativeAssetManager((Context)context);
        EglBase14 eglBase = EglBase.createEgl14((int[])EglBase.CONFIG_PLAIN);
        EglBase14.Context eglBaseContext = (EglBase14.Context)eglBase.getEglBaseContext();
        EGLContext rawEglBaseContext = eglBaseContext.getRawContext();
        EglManager eglManager = new EglManager((Object)rawEglBaseContext);
        this.frameProcessor = new FrameProcessor(graph, context, eglManager.getNativeContext(), INPUT_STREAM, OUTPUT_STREAM);
        Log.d((String)LOGTAG, (String)"FrameProcessor created for graph:");
        Log.d((String)LOGTAG, (String)graph);
        this.frameProcessor.setAsynchronousErrorListener(error -> Log.e((String)LOGTAG, (String)("FrameProcessor.AsynchronousErrorListener.onError(): " + error.toString())));
        Log.d((String)LOGTAG, (String)"FrameProcessor error listener set");
        this.converter = new ExternalTextureConverter(eglManager.getContext(), 2);
        Log.d((String)LOGTAG, (String)"TextureFrameProducer created");
        this.converter.setConsumer((TextureFrameConsumer)this.frameProcessor);
        Log.d((String)LOGTAG, (String)"TextureFrameProducer sets FrameProcessor as its consumer");
        this.videoSurfaceInputSurfaceTextureHelper = SurfaceTextureHelper.create((String)"inputSurfaceTextureHelper", (EglBase.Context)eglBase.getEglBaseContext(), (boolean)false, (YuvConverter)new YuvConverter(), (SurfaceTextureHelper.FrameRefMonitor)new SurfaceTextureHelper.FrameRefMonitor(){

            public void onNewBuffer(VideoFrame.TextureBuffer textureBuffer) {
            }

            public void onRetainBuffer(VideoFrame.TextureBuffer textureBuffer) {
            }

            public void onReleaseBuffer(VideoFrame.TextureBuffer textureBuffer) {
            }

            public void onDestroyBuffer(VideoFrame.TextureBuffer textureBuffer) {
                System.gc();
            }
        });
        this.inputSurface = new Surface(this.videoSurfaceInputSurfaceTextureHelper.getSurfaceTexture());
        this.videoSurfaceOutputSurfaceTextureHelper = SurfaceTextureHelper.create((String)"outputSurfaceTextureHelper", (EglBase.Context)eglBase.getEglBaseContext(), (boolean)false, (YuvConverter)new YuvConverter(), (SurfaceTextureHelper.FrameRefMonitor)new SurfaceTextureHelper.FrameRefMonitor(){

            public void onNewBuffer(VideoFrame.TextureBuffer textureBuffer) {
            }

            public void onRetainBuffer(VideoFrame.TextureBuffer textureBuffer) {
            }

            public void onReleaseBuffer(VideoFrame.TextureBuffer textureBuffer) {
            }

            public void onDestroyBuffer(VideoFrame.TextureBuffer textureBuffer) {
                System.gc();
            }
        });
        this.outputSurface = new Surface(this.videoSurfaceOutputSurfaceTextureHelper.getSurfaceTexture());
        this.videoSurfaceOutputSurfaceTextureHelper.startListening(videoFrame -> {
            if (this.callback == null) {
                return;
            }
            VideoFrame.I420Buffer videoFrameI420Buffer = videoFrame.getBuffer().toI420();
            if (videoFrameI420Buffer != null) {
                videoFrameI420Buffer.retain();
                this.callback.onVideoFrameTransformed(new VideoFrame((VideoFrame.Buffer)videoFrameI420Buffer, this.rotation, videoFrame.getTimestampNs()));
                videoFrameI420Buffer.release();
            }
            System.gc();
        });
        this.frameProcessor.getVideoSurfaceOutput().setFlipY(false);
        this.frameProcessor.getVideoSurfaceOutput().setSurface((Object)this.outputSurface);
        this.initialized = true;
        return true;
    }

    @CalledByNative
    void processFrameBuffer(byte[] videoFrameBuffer, int length, int width, int height, int rotation) {
        if (!this.initialized) {
            Log.w((String)LOGTAG, (String)"processFrameBuffer(): Not initialized");
            return;
        }
        if (videoFrameBuffer == null) {
            Log.w((String)LOGTAG, (String)"processFrameBuffer(): videoFrame is null");
            return;
        }
        if (this.width != width || this.height != height) {
            this.width = width;
            this.height = height;
            if (this.videoSurfaceOutputSurfaceTextureHelper != null) {
                this.videoSurfaceOutputSurfaceTextureHelper.setTextureSize(this.width, this.height);
            }
            if (this.videoSurfaceInputSurfaceTextureHelper != null) {
                this.videoSurfaceInputSurfaceTextureHelper.setTextureSize(this.width, this.height);
            }
            this.converter.setSurfaceTexture(this.videoSurfaceInputSurfaceTextureHelper.getSurfaceTexture(), this.width, this.height);
            Log.d((String)LOGTAG, (String)("processFrameBuffer(): texture is " + this.width + "x" + this.height));
        }
        if (this.rotation != rotation) {
            this.rotation = rotation;
            if (this.videoSurfaceOutputSurfaceTextureHelper != null) {
                this.videoSurfaceOutputSurfaceTextureHelper.setFrameRotation(this.rotation);
            }
            if (this.videoSurfaceInputSurfaceTextureHelper != null) {
                this.videoSurfaceInputSurfaceTextureHelper.setFrameRotation(this.rotation);
            }
            Log.d((String)LOGTAG, (String)("processFrameBuffer(): rotation is " + this.rotation));
            Integer rotationMapEnrty = WEBRTC_MEDIAPIPE_ROTATION_MAP.get(new Integer(this.rotation));
            if (rotationMapEnrty != null) {
                this.converter.setRotation(rotationMapEnrty.intValue());
            }
        }
        if (this.inputSurface != null) {
            Bitmap bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(videoFrameBuffer));
            Canvas canvas = this.inputSurface.lockCanvas(null);
            canvas.drawBitmap(bitmap, 0.0f, 0.0f, null);
            this.inputSurface.unlockCanvasAndPost(canvas);
        }
    }

    @CalledByNative
    public void close() {
        Log.d((String)LOGTAG, (String)"close()");
        if (!this.initialized) {
            Log.w((String)LOGTAG, (String)"close(): Not initialized");
            return;
        }
        if (this.videoSurfaceOutputSurfaceTextureHelper != null) {
            this.videoSurfaceOutputSurfaceTextureHelper.stopListening();
            this.videoSurfaceOutputSurfaceTextureHelper.dispose();
            this.videoSurfaceOutputSurfaceTextureHelper = null;
        }
        if (this.videoSurfaceInputSurfaceTextureHelper != null) {
            this.videoSurfaceInputSurfaceTextureHelper.stopListening();
            this.videoSurfaceInputSurfaceTextureHelper.dispose();
            this.videoSurfaceInputSurfaceTextureHelper = null;
        }
        this.converter.close();
        this.frameProcessor.close();
        if (this.inputSurface != null) {
            this.inputSurface.release();
            this.inputSurface = null;
        }
        if (this.outputSurface != null) {
            this.outputSurface.release();
            this.outputSurface = null;
        }
        if (this.eglBase != null) {
            this.eglBase.release();
            this.eglBase = null;
        }
    }

    @CalledByNative
    public static Callback createMediapipeVideoFrameProcessorCallback(long nativeMediapipeVideoFrameProcessor) {
        Log.d((String)LOGTAG, (String)"MediapipeVideoFrameProcessor.createMediapipeVideoFrameProcessorCallback()");
        return videoFrame -> MediapipeVideoFrameProcessor.nativeOnVideoFrameTransformed(nativeMediapipeVideoFrameProcessor, videoFrame);
    }

    private static native void nativeOnVideoFrameTransformed(long var0, VideoFrame var2);

    static {
        HashMap<Integer, Integer> setup = new HashMap<Integer, Integer>();
        setup.put(new Integer(0), new Integer(0));
        setup.put(new Integer(90), new Integer(1));
        setup.put(new Integer(180), new Integer(2));
        setup.put(new Integer(270), new Integer(3));
        WEBRTC_MEDIAPIPE_ROTATION_MAP = Collections.unmodifiableMap(setup);
    }

    public static interface Callback {
        public void onVideoFrameTransformed(VideoFrame var1);
    }
}

