//
//  LibYUVVideoFrameProcessor.hpp
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 08/11/2022.
//

#pragma once

#include "VideoFrameProcessorInterface.h"
#include <vector>
#define CALC_TABLE_SIZE 256

namespace cv {
class Mat;
}

namespace webrtc {
class Mutex;
}

namespace vonage {

class BackgroundBlurTFLiteHelper;
class OpenCvConvertor;

class CpuVideoFrameProcessor : public VideoFrameProcessorInterface {
public:
    CpuVideoFrameProcessor();
    virtual ~CpuVideoFrameProcessor();
    
    webrtc::MediaProcessorStatus Init(const MLTransformerBaseConfig* config) override;
    webrtc::MediaProcessorStatus ProcessFrame(webrtc::VideoFrame* video_frame) override;
    webrtc::MediaProcessorStatus SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) override;
    
private:
    webrtc::MediaProcessorStatus ValidateConfig();
    webrtc::MediaProcessorStatus InitTflite();
    void SmoothSegmentation(float* new_segmentation);
    void ProcessFinalResult(uint_fast8_t* original_image, uint_fast8_t* background_image, float* mask_image);
    void ResizeImageBackground();
    void ConvolveSegmentaion();
    
private:
    std::unique_ptr<float[]> float_prev_segmentation_mask_;
    uint_fast8_t saved_values_[CALC_TABLE_SIZE][CALC_TABLE_SIZE][CALC_TABLE_SIZE];
    
    std::unique_ptr<BackgroundBlurTFLiteHelper> tfLiteHelper_;
    BlurRadius radius_;
    uint8_t custom_radius_;
    std::unique_ptr<cv::Mat> backgound_image_;
    std::unique_ptr<OpenCvConvertor> convertor_;
    
    std::unique_ptr<uint_fast8_t[]> post_process_video_full_size_;

    std::string background_image_path_;
    BackgroundEffectType type_;
    bool initialized_;
    int current_video_width_;
    int current_video_height_;
    int total_pixel_count_;
    std::string model_path_;
    
    std::unique_ptr<webrtc::Mutex> setting_mutex_;
};
}
