#pragma once

#include "ml_transformers/ml_transformers.h"

namespace vonage {
const std::string kStatusFrameProcessorNotInitialized = std::string("Frame processor is not initialized");
const std::string KStatusFrameProcessorIsNull = std::string("Frame processor is null");
const std::string KStatusConfigurationIsNull = std::string("Configuration is null");

const std::string kStatusModelPathEmpty = std::string("Model path empty");
const std::string kStatusModelTFLiteNotValid = std::string("Model is not a valid TFLite model");
const std::string kStatusErrorReadingModelData = std::string("Read model data error");

const std::string kStatusTFLiteInitializeError = std::string("TFLite initialize error");
const std::string kStatusTFLiteInitializedWithLowPerformanceCapabilities = std::string("TFLite is initialized with low performance capabilities");
const std::string kStatusTFLiteProcessError = std::string("TFLite process error");
const std::string kStatusTFLiteRunError = std::string("TFLite run error");

const std::string kStatusMediaPipeGraphStartError = std::string("Start MediaPipe graph error");
const std::string kStatusMediaPipeGraphStartedWithError = std::string("MediaPipe graph started with error");
const std::string kStatusMediaPipeInitializeGraphError = std::string("MediaPipe initialize graph error");
const std::string kStatusMediaPipeRunError = std::string("MediaPipe run error");

const std::string kStatusBackgroundImageLoadingError = std::string("Background image can not be loaded");
const std::string kStatusInvalidRadiusArgument = std::string("Invalid radius argument");
const std::string kStatusInvalidEffectArgument = std::string("Invalid effect type argument");


const std::string kStatusCVPixelBufferError = std::string("CVPixelBuffer error");
const std::string kStatusMetalNotSupportedError = std::string("Metal not supported");
const std::string kStatusMacOsMetalFamilyNotSupportedError = std::string("MacOS Metal GPU family Apple 1 is not supported");
const std::string kStatusMacOsVersionError = std::string("Minimal MacOS version 10.15 is required for Metal");
const std::string kStatusMediaPipeNotSupportedSimulator = std::string("MediaPipe is not supported simulator");
const std::string kStatusFrameNull = std::string("Frame is null");
const std::string kStatusInvalidFrame = std::string("Invalid frame");

const std::string kAudioOptionsWarning = std::string("Vonage Noise Suppression Transformer might not provide the expected result given WebRTC audio options are enabled.");

}
