//
//  VideoFrameProcessorInterface.h
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 08/11/2022.
//

//
//  VideoFrameProcessor.h
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 08/11/2022.
//

#pragma once
#include <memory>
#include <modules/vonage/api/media_processor/media_processor_status.h>

#include "ml_transformers/ml_transformers.h"

namespace webrtc{
class VideoFrame;
}

namespace cv {
class Mat;
}

namespace vonage {

class TransformerInfoInterface;

class VideoFrameProcessorInterface{
public:
    static std::unique_ptr<VideoFrameProcessorInterface> CreateVideoFrameProcessor();
    static std::unique_ptr<VideoFrameProcessorInterface> CreateDefaultVideoFrameProcessor();
    static std::unique_ptr<uint_fast8_t[]> make_unique_uint_fast8_t_ptr(size_t size);
    static std::unique_ptr<float[]> make_unique_float_ptr(size_t size);

    virtual ~VideoFrameProcessorInterface() = default;
    virtual webrtc::MediaProcessorStatus Init(const MLTransformerBaseConfig* config) = 0;
    virtual webrtc::MediaProcessorStatus ProcessFrame(webrtc::VideoFrame* video_frame) = 0;
    virtual webrtc::MediaProcessorStatus SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) = 0;
    
protected:
    webrtc::MediaProcessorStatus UpdateMediaPipePostProcessOptions(const MLTransformerBaseConfig* base_config);
};

}
