//
//  VonageBackgroundEffectVideoTransformer.hpp
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 28/07/2022.
//

#pragma once

#include "ml_transformers/ml_transformers.h"

namespace webrtc {
class Mutex;
}

namespace vonage{

class VideoFrameProcessorInterface;

class VonageBackgroundEffectVideoTransformer : public webrtc::BaseFrameTransformer<webrtc::VideoFrame> {
public:
    VonageBackgroundEffectVideoTransformer(webrtc::BaseFrameTransformerObserver* observer);
    virtual ~VonageBackgroundEffectVideoTransformer();
    void Transform(webrtc::VideoFrame* video_frame) override;
    bool SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) override;
    
private:
    std::unique_ptr<VideoFrameProcessorInterface> frame_processor_;
    std::vector<uint64_t> full_proccess_time_;
    std::unique_ptr<webrtc::Mutex> mutex_;
};
}
