//
//  VonageNoiseSuspresionTransformer.hpp
//  ml_transformers_macos
//
//  Created by Guy Mininberg on 28/07/2022.
//

#pragma once

#include <complex>

#include "ml_transformers.h"

#include <modules/vonage/api/media_processor/media_processor_status.h>

namespace webrtc {
class WavWriter;
template <typename T> class PushResampler;
}

namespace vonage{

struct NoiseSuppressionTFLiteHelper;

class VonageNoiseSuppressionTransformer : public webrtc::BaseFrameTransformer<webrtc::AudioFrame> {
public:
    VonageNoiseSuppressionTransformer(webrtc::BaseFrameTransformerObserver* observer);
    virtual ~VonageNoiseSuppressionTransformer();
    void Transform(webrtc::AudioFrame* audio_frame) override;
    void OnAudioOptions(const cricket::AudioOptions& options) override;
    bool SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) override;
    
private:
    struct OutResamplerData {
        int sampleRate_ = 0;
        size_t numberOfChannels_ = 0;
    } out_resampler_data_;
    
    webrtc::MediaProcessorStatus InitTfLite(const std::vector<std::string>& tflite_models_path);
    webrtc::MediaProcessorStatus RunTfLite();
    std::vector<float> ProcessAudio();
    void GetPhase(std::vector<std::complex<double>> fft_res, float* in_mag, float* in_phase, int count);
    
    webrtc::MediaProcessorStatus TransformInternal(webrtc::AudioFrame* audio_frame);
    webrtc::MediaProcessorStatus SetTransformerConfigInternal(const vonage::MLTransformerBaseConfig* config);
    
private:
    std::unique_ptr<NoiseSuppressionTFLiteHelper> tfLiteHelper_;
    std::unique_ptr<webrtc::PushResampler<int16_t>> resampler16Hz_;
    std::unique_ptr<webrtc::PushResampler<int16_t>> resamplerOut_;
    std::vector<float> audio_input_container_;
    std::vector<int16_t> clean_audio_buffer_;
    std::vector<uint64_t> full_proccess_time_;
    
    std::unique_ptr<webrtc::WavWriter> output_wav;
    bool initialized_ = false;
    cricket::AudioOptions audio_options_;
};
}
