#ifndef ML_TRANSFORMERS_ANDROID_MEDIAPIPE_VIDEO_FRAME_PROCESSOR_H_
#define ML_TRANSFORMERS_ANDROID_MEDIAPIPE_VIDEO_FRAME_PROCESSOR_H_

#include <jni.h>

#include <sdk/android/src/jni/jni_helpers.h>
#include <rtc_base/synchronization/mutex.h>

#include "ml_transformers/VideoFrameProcessorInterface.h"

namespace vonage {

class AndroidMediapipeVideoFrameProcessor : public VideoFrameProcessorInterface {
public:
    AndroidMediapipeVideoFrameProcessor();
    virtual ~AndroidMediapipeVideoFrameProcessor();

    webrtc::MediaProcessorStatus Init(const MLTransformerBaseConfig* config) override;
    webrtc::MediaProcessorStatus ProcessFrame(webrtc::VideoFrame* video_frame) override;
    webrtc::MediaProcessorStatus SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) override;

    void OnVideoFrameTransformed(JNIEnv* jni, const webrtc::JavaParamRef<jobject>& video_frame);
private:
    webrtc::ScopedJavaGlobalRef<jobject> j_engine_;
    rtc::scoped_refptr<webrtc::I420BufferInterface> transformed_video_frame_buffer_;
    webrtc::Mutex result_buffer_mutex_;
    bool is_first_frame_;
};

} // namespace vonage

#endif // ML_TRANSFORMERS_ANDROID_MEDIAPIPE_VIDEO_FRAME_PROCESSOR_H_

