#pragma once

#include "ml_transformers/VideoFrameProcessorInterface.h"


namespace vonage {

class MediaPipeGraphProcessor;
class CPPMediapipeVideoFrameProcessor : public VideoFrameProcessorInterface {
public:
    CPPMediapipeVideoFrameProcessor();
    virtual ~CPPMediapipeVideoFrameProcessor();

    webrtc::MediaProcessorStatus Init(const MLTransformerBaseConfig* config) override;
    webrtc::MediaProcessorStatus ProcessFrame(webrtc::VideoFrame* video_frame) override;
    webrtc::MediaProcessorStatus SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) override;
private:
    std::unique_ptr<MediaPipeGraphProcessor> processor_;
    bool mediapipe_initialized_ = false;
};

} // namespace vonage

