//
//  VonageCameraVideoCapturer.h
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 06/12/2022.


#import <sdk/objc/base/RTCVideoCapturer.h>

NS_ASSUME_NONNULL_BEGIN

@interface VonageCameraVideoCapturer : RTC_OBJC_TYPE(RTCVideoCapturer)
+ (NSArray<AVCaptureDevice *> *)captureDevices;
+ (NSArray<AVCaptureDeviceFormat *> *)supportedFormatsForDevice:(AVCaptureDevice *)device;

-(instancetype)init;
-(instancetype)initWithDelegate:(id<RTC_OBJC_TYPE(RTCVideoCapturerDelegate)>)delegate;

-(void)setDelegate:(nullable id<RTC_OBJC_TYPE(RTCVideoCapturerDelegate)>) delegate;
-(void)removeDelegate:(nullable id<RTC_OBJC_TYPE(RTCVideoCapturerDelegate)>) delegate;
-(void)startWithDevice:(AVCaptureDevice*)device
                format:(AVCaptureDeviceFormat*)format
         sessionPreset:(AVCaptureSessionPreset)sessionPreset
         videoMirrored:(BOOL)videoMirrored
           orientation:(AVCaptureVideoOrientation)orientation
           pixelFormat:(OSType)pixelFormat
     CompletionHandler:(nonnull void (^)(NSError * _Nullable))completionHandler;
-(void)stopWithCompletionHandler:(nonnull void (^)(void))completionHandler;
@end

NS_ASSUME_NONNULL_END
