//
//  IosVideoFrameProcessor.h
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 08/11/2022.
//

#pragma once

#include "../VideoFrameProcessorInterface.h"

#include <sdk/objc/base/RTCMacros.h>

RTC_FWD_DECL_OBJC_CLASS(IosVideoFrameProcessorInternal);

namespace vonage {
class MediapipeLogSink;
class IosVideoFrameProcessor : public VideoFrameProcessorInterface{
public:
    IosVideoFrameProcessor();
    virtual ~IosVideoFrameProcessor();
    
    webrtc::MediaProcessorStatus Init(const MLTransformerBaseConfig* config) override;
    webrtc::MediaProcessorStatus ProcessFrame(webrtc::VideoFrame* video_frame) override;
    webrtc::MediaProcessorStatus SetTransformerConfig(const vonage::MLTransformerBaseConfig* config) override;
    
private:
    IosVideoFrameProcessorInternal* frame_processor_;
    std::unique_ptr<MediapipeLogSink> log_sink_;
};

}
