#ifndef ML_TRANSFORMERS_MEDIAPIPE_GRAPHS_H_
#define ML_TRANSFORMERS_MEDIAPIPE_GRAPHS_H_

#include <string>

#include "ml_transformers/ml_transformers.h"

namespace vonage {

/** Helper class providing text representation of graphs for features supported by the library.
 *
 */
class MediapipeGraph {
public:
    /** Builds and returns the text representation of the media pipe graph according the transformer configuration.
     *
     * @return Text representation of the graph.
     */
    static const std::string Build(const MLTransformerBaseConfig* config);
};

} // namespace vonage

#endif // ML_TRANSFORMERS_MEDIAPIPE_GRAPHS_H_
