/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import android.content.Context;
import android.content.res.AssetManager;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;

public final class AndroidAssetUtil {
    public static byte[] getAssetBytes(AssetManager assets, String assetName) {
        byte[] assetData;
        try {
            InputStream stream = assets.open(assetName);
            assetData = ByteStreams.toByteArray((InputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return assetData;
    }

    public static synchronized boolean initializeNativeAssetManager(Context androidContext) {
        return AndroidAssetUtil.nativeInitializeAssetManager(androidContext, androidContext.getCacheDir().getAbsolutePath());
    }

    private static native boolean nativeInitializeAssetManager(Context var0, String var1);

    private AndroidAssetUtil() {
    }
}

