/*
 * Decompiled with CFR 0.152.
 */
package com.google.mediapipe.framework;

import com.google.mediapipe.framework.GlSyncToken;
import com.google.mediapipe.framework.GraphGlSyncToken;
import com.google.mediapipe.framework.TextureFrame;

public class GraphTextureFrame
implements TextureFrame {
    private long nativeBufferHandle;
    private int textureName;
    private int width;
    private int height;
    private long timestamp = Long.MIN_VALUE;
    private final boolean deferredSync;

    GraphTextureFrame(long nativeHandle, long timestamp) {
        this(nativeHandle, timestamp, false);
    }

    GraphTextureFrame(long nativeHandle, long timestamp, boolean deferredSync) {
        this.nativeBufferHandle = nativeHandle;
        this.textureName = this.nativeGetTextureName(this.nativeBufferHandle);
        this.width = this.nativeGetWidth(this.nativeBufferHandle);
        this.height = this.nativeGetHeight(this.nativeBufferHandle);
        this.timestamp = timestamp;
        this.deferredSync = deferredSync;
    }

    @Override
    public int getTextureName() {
        if (this.nativeBufferHandle == 0L) {
            return 0;
        }
        if (this.deferredSync) {
            this.nativeGpuWait(this.nativeBufferHandle);
        }
        return this.textureName;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void release() {
        GraphGlSyncToken consumerToken = new GraphGlSyncToken(this.nativeCreateSyncTokenForCurrentExternalContext(this.nativeBufferHandle));
        this.release(consumerToken);
    }

    @Override
    public void release(GlSyncToken consumerSyncToken) {
        if (this.nativeBufferHandle != 0L) {
            long token = consumerSyncToken == null ? 0L : consumerSyncToken.nativeToken();
            this.nativeReleaseBuffer(this.nativeBufferHandle, token);
            this.nativeBufferHandle = 0L;
        }
        if (consumerSyncToken != null) {
            consumerSyncToken.release();
        }
    }

    private native void nativeReleaseBuffer(long var1, long var3);

    private native int nativeGetTextureName(long var1);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private native void nativeGpuWait(long var1);

    private native long nativeCreateSyncTokenForCurrentExternalContext(long var1);
}

