//
//  LibYUVVideoFrameProcessor.hpp
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 08/11/2022.
//

#pragma once

#include <mutex>
#include <vector>

#include "VideoFrameProcessorInterface.h"

#define CALC_TABLE_SIZE 256

namespace cv {
class Mat;
}

namespace vonage {

class BackgroundBlurTFLiteHelper;
class OpenCvConvertor;

class CpuVideoFrameProcessor : public VideoFrameProcessorInterface {
public:
    CpuVideoFrameProcessor();
    virtual ~CpuVideoFrameProcessor();
    
    virtual uint8_t Init(const BaseBackgroundEffectConfig* config) override;
    virtual uint8_t ProcessFrame(int width, int height,
                                 uint8_t* data_y, int stride_y,
                                 uint8_t* data_u, int stride_u,
                                 uint8_t* data_v, int stride_v,
                                 int rotation,
                                 uint64_t timestamp_ms) override;
#if defined(WEBRTC_MAC) || defined(WEBRTC_IOS)
    virtual uint8_t AppleProcessFrame(CVPixelBufferRef buffer,
                                      int rotation,
                                      uint64_t timestamp_us) override;
#endif
    virtual uint8_t SetTransformerConfig(const BaseBackgroundEffectConfig* config) override;

private:
    uint8_t ValidateConfig();
    uint8_t InitTflite();
    void SmoothSegmentation(float* new_segmentation);
    void ProcessFinalResult(uint_fast8_t* original_image, uint_fast8_t* background_image, float* mask_image);
    void ResizeImageBackground();
    void ConvolveSegmentaion();
    
private:
    std::unique_ptr<float[]> float_prev_segmentation_mask_;
    uint_fast8_t saved_values_[CALC_TABLE_SIZE][CALC_TABLE_SIZE][CALC_TABLE_SIZE];
    
    std::unique_ptr<BackgroundBlurTFLiteHelper> tfLiteHelper_;
    BlurRadius radius_;
    uint8_t custom_radius_;
    std::unique_ptr<cv::Mat> backgound_image_;
    std::unique_ptr<OpenCvConvertor> convertor_;
    
    std::unique_ptr<uint_fast8_t[]> post_process_video_full_size_;

    std::string background_image_path_;
    BackgroundEffectType type_;
    bool initialized_;
    int current_video_width_;
    int current_video_height_;
    int total_pixel_count_;
    std::string model_path_;
    
    std::mutex setting_mutex_;
};
}
