//
//  GPUDelegateHelper.hpp
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 26/10/2022.
//

#pragma once

#include <memory>


struct TfLiteDelegate;

namespace vonage {

class GPUDelegateHelperFactory{
public:
    static TfLiteDelegate* CreateGPUDelegate();
    static void DeleteGPUDelegate(TfLiteDelegate* delegate);
};

class GPUDelegateHelperInterface {
public:
    virtual ~GPUDelegateHelperInterface() = default;
    virtual TfLiteDelegate* CreateDelegate() = 0;
    virtual void DeleteDelegate(TfLiteDelegate* delegate) = 0;
};

}

