//
//  ImageLoaderInterface.h
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 28/05/2023.
//

#pragma once

#include <string>
#include <memory>
#include <opencv2/core/mat.hpp>

namespace vonage {
class ImageLoaderInterface{
public:
    virtual ~ImageLoaderInterface() = default;
    static std::unique_ptr<cv::Mat> LoadImageToMat(const std::string& image_path, bool isGpuBuffer);
private:
    virtual std::unique_ptr<cv::Mat> LoadImageToMatImpl(const std::string& image_path, bool isGpuBuffer) = 0;
};

}
