#pragma once

#include "ml_transformers/VideoFrameProcessorInterface.h"

namespace vonage {

class MediaPipeGraphProcessor;
class CPPMediapipeVideoFrameProcessor : public VideoFrameProcessorInterface {
public:
    CPPMediapipeVideoFrameProcessor();
    virtual ~CPPMediapipeVideoFrameProcessor();

    virtual uint8_t Init(const BaseBackgroundEffectConfig* config) override;
    virtual uint8_t ProcessFrame(int width, int height,
                                 uint8_t* data_y, int stride_y,
                                 uint8_t* data_u, int stride_u,
                                 uint8_t* data_v, int stride_v,
                                 int rotation,
                                 uint64_t timestamp_ms) override;
#if defined(WEBRTC_MAC) || defined(WEBRTC_IOS)
    virtual uint8_t AppleProcessFrame(CVPixelBufferRef buffer,
                                      int rotation,
                                      uint64_t timestamp_us) override;
#endif
    virtual uint8_t SetTransformerConfig(const BaseBackgroundEffectConfig* config) override;

private:
    std::unique_ptr<MediaPipeGraphProcessor> processor_;
};

} // namespace vonage

