//
//  IosVideoFrameProcessor.h
//  ml_transformers_iphoneos
//
//  Created by Guy Mininberg on 08/11/2022.
//

#pragma once

#include "../VideoFrameProcessorInterface.h"

RTC_FWD_DECL_OBJC_CLASS(IosVideoFrameProcessorInternal);

namespace vonage {
class MediapipeLogSink;
class IosVideoFrameProcessor : public VideoFrameProcessorInterface{
public:
    IosVideoFrameProcessor();
    virtual ~IosVideoFrameProcessor();
    
    virtual uint8_t Init(const BaseBackgroundEffectConfig* config) override;
    virtual uint8_t ProcessFrame(int width, int height,
                                 uint8_t* data_y, int stride_y,
                                 uint8_t* data_u, int stride_u,
                                 uint8_t* data_v, int stride_v,
                                 int rotation,
                                 uint64_t timestamp_ms) override;
    virtual uint8_t AppleProcessFrame(CVPixelBufferRef buffer,
                                      int rotation,
                                      uint64_t timestamp_us) override;
    virtual uint8_t SetTransformerConfig(const BaseBackgroundEffectConfig* config) override;

private:
    IosVideoFrameProcessorInternal* frame_processor_;
    std::unique_ptr<MediapipeLogSink> log_sink_;
};

}
