/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.VonageClientException;
import com.vonage.client.VonageMethodFailedException;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import com.vonage.client.auth.AuthMethod;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.BasicResponseHandler;

public abstract class AbstractMethod<RequestT, ResultT>
implements RestEndpoint<RequestT, ResultT> {
    private static final Log LOG = LogFactory.getLog(AbstractMethod.class);
    protected static final BasicResponseHandler basicResponseHandler = new BasicResponseHandler();
    protected final HttpWrapper httpWrapper;
    private Set<Class<? extends AuthMethod>> acceptable;

    public AbstractMethod(HttpWrapper httpWrapper) {
        this.httpWrapper = httpWrapper;
    }

    public HttpWrapper getHttpWrapper() {
        return this.httpWrapper;
    }

    protected ResultT postProcessParsedResponse(ResultT response) {
        return response;
    }

    @Override
    public ResultT execute(RequestT request) throws VonageResponseParseException, VonageClientException {
        try {
            HttpUriRequest httpRequest = this.applyAuth(this.makeRequest(request)).setHeader("User-Agent", this.httpWrapper.getUserAgent()).setCharset(StandardCharsets.UTF_8).build();
            HttpResponse response = this.httpWrapper.getHttpClient().execute(httpRequest);
            try {
                return this.postProcessParsedResponse(this.parseResponse(response));
            }
            catch (IOException io) {
                throw new VonageResponseParseException("Unable to parse response.", io);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new VonageUnexpectedException("UTF-8 encoding is not supported by this JVM.", uee);
        }
        catch (IOException io) {
            throw new VonageMethodFailedException("Something went wrong while executing the HTTP request: " + io.getMessage() + ".", io);
        }
    }

    protected RequestBuilder applyAuth(RequestBuilder request) throws VonageClientException {
        return this.getAuthMethod(this.getAcceptableAuthMethods()).apply(request);
    }

    protected AuthMethod getAuthMethod(Class<?>[] acceptableAuthMethods) throws VonageClientException {
        if (this.acceptable == null) {
            this.acceptable = Arrays.stream(acceptableAuthMethods).filter(AuthMethod.class::isAssignableFrom).map(c -> c).collect(Collectors.toSet());
        }
        return this.httpWrapper.getAuthCollection().getAcceptableAuthMethod(this.acceptable);
    }

    protected AuthMethod getAuthMethod() throws VonageUnexpectedException {
        return this.getAuthMethod(this.getAcceptableAuthMethods());
    }

    public String getApplicationIdOrApiKey() throws VonageUnexpectedException {
        AuthMethod am = this.getAuthMethod();
        if (am instanceof JWTAuthMethod) {
            return ((JWTAuthMethod)am).getApplicationId();
        }
        if (am instanceof TokenAuthMethod) {
            return ((TokenAuthMethod)am).getApiKey();
        }
        if (am instanceof SignatureAuthMethod) {
            return ((SignatureAuthMethod)am).getApiKey();
        }
        throw new IllegalStateException(am.getClass().getSimpleName() + " does not have API key.");
    }

    protected abstract Class<?>[] getAcceptableAuthMethods();

    public abstract RequestBuilder makeRequest(RequestT var1) throws UnsupportedEncodingException;

    public abstract ResultT parseResponse(HttpResponse var1) throws IOException;
}

