/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

public class HttpConfig {
    private static final String DEFAULT_API_BASE_URI = "https://api.nexmo.com";
    private static final String DEFAULT_REST_BASE_URI = "https://rest.nexmo.com";
    private static final String DEFAULT_API_EU_BASE_URI = "https://api-eu.vonage.com";
    private static final String DEFAULT_VIDEO_BASE_URI = "https://video.api.vonage.com";
    private final int timeoutMillis;
    private final String apiBaseUri;
    private final String restBaseUri;
    private final String apiEuBaseUri;
    private final String videoBaseUri;

    private HttpConfig(Builder builder) {
        this.timeoutMillis = builder.timeoutMillis;
        if (this.timeoutMillis < 10) {
            throw new IllegalArgumentException("Timeout must be greater than 10ms.");
        }
        this.apiBaseUri = builder.apiBaseUri;
        this.restBaseUri = builder.restBaseUri;
        this.videoBaseUri = builder.videoBaseUri;
        this.apiEuBaseUri = builder.apiEuBaseUri;
    }

    public int getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public String getApiBaseUri() {
        return this.apiBaseUri;
    }

    public String getRestBaseUri() {
        return this.restBaseUri;
    }

    public String getVideoBaseUri() {
        return this.videoBaseUri;
    }

    public String getApiEuBaseUri() {
        return this.apiEuBaseUri;
    }

    public boolean isDefaultApiBaseUri() {
        return DEFAULT_API_BASE_URI.equals(this.apiBaseUri);
    }

    public boolean isDefaultRestBaseUri() {
        return DEFAULT_REST_BASE_URI.equals(this.restBaseUri);
    }

    public boolean isDefaultApiEuBaseUri() {
        return DEFAULT_API_EU_BASE_URI.equals(this.apiEuBaseUri);
    }

    public boolean isDefaultVideoBaseUri() {
        return DEFAULT_VIDEO_BASE_URI.equals(this.videoBaseUri);
    }

    public String getVersionedApiBaseUri(String version) {
        return this.appendVersionToUri(this.apiBaseUri, version);
    }

    public String getVersionedRestBaseUri(String version) {
        return this.appendVersionToUri(this.restBaseUri, version);
    }

    public String getVersionedApiEuBaseUri(String version) {
        return this.appendVersionToUri(this.apiEuBaseUri, version);
    }

    public String getVersionedVideoBaseUri(String version) {
        return this.appendVersionToUri(this.videoBaseUri, version);
    }

    private String appendVersionToUri(String uri, String version) {
        return uri + "/" + version;
    }

    public static HttpConfig defaultConfig() {
        return new Builder().build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int timeoutMillis = 60000;
        private String apiBaseUri = "https://api.nexmo.com";
        private String restBaseUri = "https://rest.nexmo.com";
        private String apiEuBaseUri = "https://api-eu.vonage.com";
        private String videoBaseUri = "https://video.api.vonage.com";

        public Builder timeoutMillis(int timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public Builder apiBaseUri(String apiBaseUri) {
            this.apiBaseUri = this.sanitizeUri(apiBaseUri);
            return this;
        }

        public Builder restBaseUri(String restBaseUri) {
            this.restBaseUri = this.sanitizeUri(restBaseUri);
            return this;
        }

        public Builder apiEuBaseUri(String apiEuBaseUri) {
            this.apiEuBaseUri = this.sanitizeUri(apiEuBaseUri);
            return this;
        }

        public Builder videoBaseUri(String videoBaseUri) {
            this.videoBaseUri = this.sanitizeUri(videoBaseUri);
            return this;
        }

        public Builder baseUri(String baseUri) {
            String sanitizedUri;
            this.apiBaseUri = sanitizedUri = this.sanitizeUri(baseUri);
            this.restBaseUri = sanitizedUri;
            this.apiEuBaseUri = sanitizedUri;
            this.videoBaseUri = sanitizedUri;
            return this;
        }

        public HttpConfig build() {
            return new HttpConfig(this);
        }

        private String sanitizeUri(String uri) {
            if (uri != null && uri.endsWith("/")) {
                return uri.substring(0, uri.length() - 1);
            }
            return uri;
        }
    }
}

