/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.vonage.client.VonageResponseParseException;
import com.vonage.client.VonageUnexpectedException;
import java.io.IOException;
import java.lang.reflect.Constructor;

public interface Jsonable {
    public static ObjectMapper createDefaultObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        return mapper;
    }

    default public String toJson() {
        try {
            return Jsonable.createDefaultObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException jpe) {
            throw new VonageUnexpectedException("Failed to produce JSON from " + this.getClass().getSimpleName() + " object.", jpe);
        }
    }

    default public void updateFromJson(String json) {
        if (json == null || json.trim().isEmpty()) {
            return;
        }
        try {
            Jsonable.createDefaultObjectMapper().readerForUpdating((Object)this).readValue(json);
        }
        catch (IOException ex) {
            throw new VonageResponseParseException("Failed to produce " + this.getClass().getSimpleName() + " from json.", ex);
        }
    }

    public static <J extends Jsonable> J fromJson(String json, J ... type) {
        return (J)Jsonable.fromJson(json, type.getClass().getComponentType());
    }

    public static <J extends Jsonable> J fromJson(String json, Class<? extends J> jsonable) {
        try {
            Constructor<J> constructor = jsonable.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            Jsonable instance = (Jsonable)constructor.newInstance(new Object[0]);
            instance.updateFromJson(json);
            return (J)instance;
        }
        catch (ReflectiveOperationException ex) {
            throw new VonageUnexpectedException(ex);
        }
    }
}

