/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client;

import com.vonage.client.HttpConfig;
import com.vonage.client.HttpWrapper;
import com.vonage.client.VonageClientCreationException;
import com.vonage.client.VonageUnableToReadPrivateKeyException;
import com.vonage.client.account.AccountClient;
import com.vonage.client.application.ApplicationClient;
import com.vonage.client.auth.AuthCollection;
import com.vonage.client.auth.JWTAuthMethod;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.auth.VonageUnacceptableAuthException;
import com.vonage.client.auth.hashutils.HashUtil;
import com.vonage.client.conversion.ConversionClient;
import com.vonage.client.insight.InsightClient;
import com.vonage.client.meetings.MeetingsClient;
import com.vonage.client.messages.MessagesClient;
import com.vonage.client.numbers.NumbersClient;
import com.vonage.client.proactiveconnect.ProactiveConnectClient;
import com.vonage.client.redact.RedactClient;
import com.vonage.client.sms.SmsClient;
import com.vonage.client.subaccounts.SubaccountsClient;
import com.vonage.client.users.UsersClient;
import com.vonage.client.verify.VerifyClient;
import com.vonage.client.verify2.Verify2Client;
import com.vonage.client.video.VideoClient;
import com.vonage.client.voice.VoiceClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import org.apache.http.client.HttpClient;

public class VonageClient {
    private final HttpWrapper httpWrapper;
    private final AccountClient account;
    private final ApplicationClient application;
    private final InsightClient insight;
    private final NumbersClient numbers;
    private final SmsClient sms;
    private final VoiceClient voice;
    private final VerifyClient verify;
    private final ConversionClient conversion;
    private final RedactClient redact;
    private final MessagesClient messages;
    private final Verify2Client verify2;
    private final SubaccountsClient subaccounts;
    private final ProactiveConnectClient proactiveConnect;
    private final MeetingsClient meetings;
    private final UsersClient users;
    private final VideoClient video;

    private VonageClient(Builder builder) {
        this.httpWrapper = new HttpWrapper(builder.httpConfig, builder.authCollection);
        this.httpWrapper.setHttpClient(builder.httpClient);
        this.account = new AccountClient(this.httpWrapper);
        this.application = new ApplicationClient(this.httpWrapper);
        this.insight = new InsightClient(this.httpWrapper);
        this.numbers = new NumbersClient(this.httpWrapper);
        this.verify = new VerifyClient(this.httpWrapper);
        this.voice = new VoiceClient(this.httpWrapper);
        this.sms = new SmsClient(this.httpWrapper);
        this.conversion = new ConversionClient(this.httpWrapper);
        this.redact = new RedactClient(this.httpWrapper);
        this.messages = new MessagesClient(this.httpWrapper);
        this.verify2 = new Verify2Client(this.httpWrapper);
        this.subaccounts = new SubaccountsClient(this.httpWrapper);
        this.proactiveConnect = new ProactiveConnectClient(this.httpWrapper);
        this.meetings = new MeetingsClient(this.httpWrapper);
        this.users = new UsersClient(this.httpWrapper);
        this.video = new VideoClient(this.httpWrapper);
    }

    public AccountClient getAccountClient() {
        return this.account;
    }

    public ApplicationClient getApplicationClient() {
        return this.application;
    }

    public InsightClient getInsightClient() {
        return this.insight;
    }

    public NumbersClient getNumbersClient() {
        return this.numbers;
    }

    public SmsClient getSmsClient() {
        return this.sms;
    }

    public VerifyClient getVerifyClient() {
        return this.verify;
    }

    public VoiceClient getVoiceClient() {
        return this.voice;
    }

    public ConversionClient getConversionClient() {
        return this.conversion;
    }

    public RedactClient getRedactClient() {
        return this.redact;
    }

    public MessagesClient getMessagesClient() {
        return this.messages;
    }

    public ProactiveConnectClient getProactiveConnectClient() {
        return this.proactiveConnect;
    }

    public MeetingsClient getMeetingsClient() {
        return this.meetings;
    }

    public Verify2Client getVerify2Client() {
        return this.verify2;
    }

    public SubaccountsClient getSubaccountsClient() {
        return this.subaccounts;
    }

    public UsersClient getUsersClient() {
        return this.users;
    }

    public VideoClient getVideoClient() {
        return this.video;
    }

    public String generateJwt() throws VonageUnacceptableAuthException {
        JWTAuthMethod authMethod = this.httpWrapper.getAuthCollection().getAuth(JWTAuthMethod.class);
        return authMethod.generateToken();
    }

    HttpWrapper getHttpWrapper() {
        return this.httpWrapper;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AuthCollection authCollection;
        private HttpConfig httpConfig = HttpConfig.defaultConfig();
        private HttpClient httpClient;
        private String applicationId;
        private String apiKey;
        private String apiSecret;
        private String signatureSecret;
        private byte[] privateKeyContents;
        private HashUtil.HashType hashType = HashUtil.HashType.MD5;

        public Builder httpConfig(HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        @Deprecated
        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder applicationId(UUID applicationId) {
            return this.applicationId(applicationId.toString());
        }

        public Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder apiSecret(String apiSecret) {
            this.apiSecret = apiSecret;
            return this;
        }

        public Builder signatureSecret(String signatureSecret) {
            this.signatureSecret = signatureSecret;
            return this;
        }

        public Builder hashType(HashUtil.HashType hashType) {
            this.hashType = hashType;
            return this;
        }

        public Builder privateKeyContents(byte[] privateKeyContents) {
            this.privateKeyContents = privateKeyContents;
            return this;
        }

        public Builder privateKeyContents(String privateKeyContents) {
            return this.privateKeyContents(privateKeyContents.getBytes());
        }

        public Builder privateKeyPath(Path privateKeyPath) throws VonageUnableToReadPrivateKeyException {
            try {
                return this.privateKeyContents(Files.readAllBytes(privateKeyPath));
            }
            catch (IOException e) {
                throw new VonageUnableToReadPrivateKeyException("Unable to read private key at " + privateKeyPath, e);
            }
        }

        public Builder privateKeyPath(String privateKeyPath) throws VonageUnableToReadPrivateKeyException {
            return this.privateKeyPath(Paths.get(privateKeyPath, new String[0]));
        }

        public VonageClient build() {
            this.authCollection = this.generateAuthCollection(this.applicationId, this.apiKey, this.apiSecret, this.signatureSecret, this.privateKeyContents, this.hashType);
            return new VonageClient(this);
        }

        private AuthCollection generateAuthCollection(String applicationId, String key, String secret, String signature, byte[] privateKeyContents, HashUtil.HashType hashType) {
            AuthCollection authMethods = new AuthCollection();
            try {
                this.validateAuthParameters(applicationId, key, secret, signature, privateKeyContents);
            }
            catch (IllegalStateException e) {
                throw new VonageClientCreationException("Failed to generate authentication methods.", e);
            }
            if (key != null && secret != null) {
                authMethods.add(new TokenAuthMethod(key, secret));
            }
            if (key != null && signature != null) {
                authMethods.add(new SignatureAuthMethod(key, signature, hashType));
            }
            if (applicationId != null && privateKeyContents != null) {
                authMethods.add(new JWTAuthMethod(applicationId, privateKeyContents));
            }
            return authMethods;
        }

        private void validateAuthParameters(String applicationId, String key, String secret, String signature, byte[] privateKeyContents) {
            if (key != null && secret == null && signature == null) {
                throw new IllegalStateException("You must provide an API secret or signature secret in addition to your API key.");
            }
            if (secret != null && key == null) {
                throw new IllegalStateException("You must provide an API key in addition to your API secret.");
            }
            if (signature != null && key == null) {
                throw new IllegalStateException("You must provide an API key in addition to your signature secret.");
            }
            if (applicationId == null && privateKeyContents != null) {
                throw new IllegalStateException("You must provide an application ID in addition to your private key.");
            }
            if (applicationId != null && privateKeyContents == null) {
                throw new IllegalStateException("You must provide a private key in addition to your application id.");
            }
        }
    }
}

