/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.vonage.client.DynamicEndpoint;
import com.vonage.client.HttpConfig;
import com.vonage.client.HttpWrapper;
import com.vonage.client.RestEndpoint;
import com.vonage.client.account.AccountResponseException;
import com.vonage.client.account.BalanceResponse;
import com.vonage.client.account.CreateSecretRequest;
import com.vonage.client.account.FullPricingRequest;
import com.vonage.client.account.FullPricingResponse;
import com.vonage.client.account.ListSecretsResponse;
import com.vonage.client.account.PrefixPricingRequest;
import com.vonage.client.account.PrefixPricingResponse;
import com.vonage.client.account.PricingRequest;
import com.vonage.client.account.PricingResponse;
import com.vonage.client.account.SecretRequest;
import com.vonage.client.account.SecretResponse;
import com.vonage.client.account.ServiceType;
import com.vonage.client.account.SettingsRequest;
import com.vonage.client.account.SettingsResponse;
import com.vonage.client.account.TopUpRequest;
import com.vonage.client.auth.SignatureAuthMethod;
import com.vonage.client.auth.TokenAuthMethod;
import com.vonage.client.common.HttpMethod;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;

public class AccountClient {
    final Supplier<String> apiKeyGetter = () -> wrapper.getAuthCollection().getAuth(TokenAuthMethod.class).getApiKey();
    final RestEndpoint<Void, BalanceResponse> balance;
    final RestEndpoint<PricingRequest, PricingResponse> pricing;
    final RestEndpoint<FullPricingRequest, FullPricingResponse> fullPricing;
    final RestEndpoint<PrefixPricingRequest, PrefixPricingResponse> prefixPricing;
    final RestEndpoint<TopUpRequest, Void> topUp;
    final RestEndpoint<SettingsRequest, SettingsResponse> settings;
    final RestEndpoint<String, ListSecretsResponse> listSecrets;
    final RestEndpoint<SecretRequest, SecretResponse> getSecret;
    final RestEndpoint<CreateSecretRequest, SecretResponse> createSecret;
    final RestEndpoint<SecretRequest, Void> revokeSecret;

    public AccountClient(final HttpWrapper wrapper) {
        /*
         * Exception performing whole class analysis ignored.
         */
        class Endpoint<T, R>
        extends DynamicEndpoint<T, R> {
            static final String SECRETS_PATH = "s/%s/secrets";
            final /* synthetic */ HttpWrapper val$wrapper;
            final /* synthetic */ AccountClient this$0;

            Endpoint(Function<T, String> pathGetter, R ... type) {
                this(this$0, pathGetter, HttpMethod.GET, type, var4_4);
            }

            Endpoint(Function<T, String> pathGetter, HttpMethod method, R ... type) {
                this(this$0, pathGetter, method, false, method == HttpMethod.POST, type, var5_5);
            }

            Endpoint(Function<T, String> pathGetter, HttpMethod method, boolean signatureAuth, boolean formEncoded, R ... type) {
                this.this$0 = this$0;
                this.val$wrapper = var7_7;
                super(DynamicEndpoint.builder(type).wrapper(var7_7).requestMethod(method).applyAsBasicAuth(signatureAuth).authMethod(TokenAuthMethod.class, signatureAuth ? SignatureAuthMethod.class : null).responseExceptionType(AccountResponseException.class).contentTypeHeader(formEncoded ? "application/x-www-form-urlencoded" : null).pathGetter((de, req) -> {
                    HttpConfig config = de.getHttpWrapper().getHttpConfig();
                    String base = signatureAuth ? config.getApiBaseUri() : config.getRestBaseUri();
                    return base + "/account" + (String)pathGetter.apply(req);
                }));
            }
        }
        this.balance = new Endpoint(this, req -> "/get-balance", (Object[])new BalanceResponse[0], wrapper);
        this.pricing = new Endpoint(this, req -> "/get-pricing/outbound/" + req.getServiceType(), (Object[])new PricingResponse[0], wrapper);
        this.fullPricing = new Endpoint(this, req -> "/get-full-pricing/outbound/" + (Object)((Object)req.getServiceType()), (Object[])new FullPricingResponse[0], wrapper);
        this.prefixPricing = new Endpoint(this, req -> "/get-prefix-pricing/outbound/" + (Object)((Object)req.getServiceType()), (Object[])new PrefixPricingResponse[0], wrapper);
        this.topUp = new Endpoint(this, req -> "/top-up", HttpMethod.POST, (Object[])new Void[0], wrapper);
        this.settings = new Endpoint(this, req -> "/settings", HttpMethod.POST, (Object[])new SettingsResponse[0], wrapper);
        class SecretsEndpoint<T, R>
        extends Endpoint<T, R> {
            SecretsEndpoint(Function<T, String> apiKeyGetter, HttpMethod method, R ... type) {
                super((AccountClient)this$0, req -> String.format("s/%s/secrets", apiKeyGetter.apply(req)), method, true, false, (Object[])type, (HttpWrapper)var5_5);
            }
        }
        this.listSecrets = new SecretsEndpoint(Function.identity(), HttpMethod.GET, (Object[])new ListSecretsResponse[0]);
        this.createSecret = new SecretsEndpoint(CreateSecretRequest::getApiKey, HttpMethod.POST, (Object[])new SecretResponse[0]);
        class SecretRequestEndpoint<R>
        extends Endpoint<SecretRequest, R> {
            SecretRequestEndpoint(HttpMethod method, R ... type) {
                super((AccountClient)this$0, req -> String.format("s/%s/secrets", req.getApiKey()) + "/" + req.getSecretId(), method, true, false, (Object[])type, (HttpWrapper)var4_4);
            }
        }
        this.getSecret = new SecretRequestEndpoint(HttpMethod.GET, (Object[])new SecretResponse[0]);
        this.revokeSecret = new SecretRequestEndpoint(HttpMethod.DELETE, (Object[])new Void[0]);
    }

    public BalanceResponse getBalance() throws AccountResponseException {
        return this.balance.execute(null);
    }

    public List<PricingResponse> listPriceAllCountries(ServiceType service) {
        Objects.requireNonNull(service, "Service type is required.");
        return this.fullPricing.execute(new FullPricingRequest(service)).getCountries();
    }

    public PricingResponse getVoicePrice(String country) throws AccountResponseException {
        return this.pricing.execute(new PricingRequest(country, ServiceType.VOICE));
    }

    public PricingResponse getSmsPrice(String country) throws AccountResponseException {
        return this.pricing.execute(new PricingRequest(country, ServiceType.SMS));
    }

    public PrefixPricingResponse getPrefixPrice(ServiceType type, String prefix) throws AccountResponseException {
        return this.prefixPricing.execute(new PrefixPricingRequest(type, prefix));
    }

    public void topUp(String transaction) throws AccountResponseException {
        this.topUp.execute(new TopUpRequest(transaction));
    }

    public ListSecretsResponse listSecrets() throws AccountResponseException {
        return this.listSecrets(this.apiKeyGetter.get());
    }

    public ListSecretsResponse listSecrets(String apiKey) throws AccountResponseException {
        if (apiKey == null || apiKey.trim().isEmpty()) {
            throw new IllegalArgumentException("API key is required.");
        }
        return this.listSecrets.execute(apiKey);
    }

    public SecretResponse getSecret(String secretId) throws AccountResponseException {
        return this.getSecret(this.apiKeyGetter.get(), secretId);
    }

    public SecretResponse getSecret(String apiKey, String secretId) throws AccountResponseException {
        return this.getSecret.execute(new SecretRequest(apiKey, secretId));
    }

    public SecretResponse createSecret(String secret) throws AccountResponseException {
        return this.createSecret(this.apiKeyGetter.get(), secret);
    }

    public SecretResponse createSecret(String apiKey, String secret) throws AccountResponseException {
        return this.createSecret.execute(new CreateSecretRequest(apiKey, secret));
    }

    public void revokeSecret(String secretId) throws AccountResponseException {
        this.revokeSecret(this.apiKeyGetter.get(), secretId);
    }

    public void revokeSecret(String apiKey, String secretId) throws AccountResponseException {
        this.revokeSecret.execute(new SecretRequest(apiKey, secretId));
    }

    public SettingsResponse updateSmsIncomingUrl(String url) throws AccountResponseException {
        return this.updateSettings(SettingsRequest.withIncomingSmsUrl(url));
    }

    public SettingsResponse updateDeliveryReceiptUrl(String url) throws AccountResponseException {
        return this.updateSettings(SettingsRequest.withDeliveryReceiptUrl(url));
    }

    public SettingsResponse updateSettings(SettingsRequest request) throws AccountResponseException {
        return this.settings.execute(Objects.requireNonNull(request, "Settings request cannot be null."));
    }
}

