/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.math.BigDecimal;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Network {
    private Type type;
    private BigDecimal price;
    private String currency;
    private String mcc;
    private String mnc;
    private String code;
    private String name;

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="price")
    public BigDecimal getPrice() {
        return this.price;
    }

    @JsonProperty(value="currency")
    public String getCurrency() {
        return this.currency;
    }

    @JsonProperty(value="mcc")
    public String getMcc() {
        return this.mcc;
    }

    @JsonProperty(value="mnc")
    public String getMnc() {
        return this.mnc;
    }

    @JsonProperty(value="networkCode")
    public String getCode() {
        return this.code;
    }

    @JsonProperty(value="networkName")
    public String getName() {
        return this.name;
    }

    public static enum Type {
        MOBILE,
        LANDLINE,
        PAGER,
        LANDLINE_TOLLFREE,
        UNKNOWN;


        @JsonValue
        public String toString() {
            return this.name().toLowerCase();
        }

        @JsonCreator
        public static Type fromString(String type) {
            try {
                return Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                return UNKNOWN;
            }
        }
    }
}

