/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.vonage.client.Jsonable;
import com.vonage.client.application.capabilities.Capability;
import com.vonage.client.application.capabilities.Messages;
import com.vonage.client.application.capabilities.Rtc;
import com.vonage.client.application.capabilities.Vbc;
import com.vonage.client.application.capabilities.Voice;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Application
implements Jsonable {
    private String id;
    private String name;
    private Keys keys;
    private Capabilities capabilities;
    private Privacy privacy;

    private Application() {
    }

    private Application(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.keys = builder.keys;
        this.capabilities = builder.capabilities;
        this.privacy = builder.privacy;
    }

    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="keys")
    public Keys getKeys() {
        return this.keys;
    }

    @JsonProperty(value="capabilities")
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @JsonProperty(value="privacy")
    public Privacy getPrivacy() {
        return this.privacy;
    }

    public static Application fromJson(String json) {
        return (Application)Jsonable.fromJson((String)json, (Jsonable[])new Application[0]);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Application application) {
        return new Builder(application);
    }

    public static class Builder {
        private Privacy privacy;
        private String id;
        private String name;
        private Keys keys;
        private Capabilities capabilities;

        public Builder() {
        }

        public Builder(Application application) {
            this.id = application.id;
            this.name = application.name;
            this.keys = application.keys;
            this.capabilities = application.capabilities;
        }

        public Builder improveAi(boolean improveAi) {
            if (this.privacy == null) {
                this.privacy = new Privacy();
            }
            this.privacy.improveAi = improveAi;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder publicKey(String publicKey) {
            this.keys = new Keys();
            this.keys.publicKey = publicKey;
            return this;
        }

        public Builder addCapability(Capability capability) {
            if (this.capabilities == null) {
                this.capabilities = new Capabilities();
            }
            this.capabilities.setCapability(capability);
            return this;
        }

        public Builder removeCapability(Capability.Type type) {
            if (this.capabilities != null) {
                boolean noCapabilities;
                this.capabilities.setCapability(type, null);
                boolean bl = noCapabilities = this.capabilities.voice == null && this.capabilities.rtc == null && this.capabilities.messages == null && this.capabilities.vbc == null;
                if (noCapabilities) {
                    this.capabilities = null;
                }
            }
            return this;
        }

        public Application build() {
            return new Application(this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Capabilities {
        private Voice voice;
        private Messages messages;
        private Rtc rtc;
        private Vbc vbc;

        @JsonProperty(value="voice")
        public Voice getVoice() {
            return this.voice;
        }

        @JsonProperty(value="messages")
        public Messages getMessages() {
            return this.messages;
        }

        @JsonProperty(value="rtc")
        public Rtc getRtc() {
            return this.rtc;
        }

        @JsonProperty(value="vbc")
        public Vbc getVbc() {
            return this.vbc;
        }

        private void setCapability(Capability.Type type, Capability capability) {
            switch (type) {
                case VOICE: {
                    this.voice = (Voice)capability;
                    break;
                }
                case MESSAGES: {
                    this.messages = (Messages)capability;
                    break;
                }
                case RTC: {
                    this.rtc = (Rtc)capability;
                    break;
                }
                case VBC: {
                    this.vbc = (Vbc)capability;
                }
            }
        }

        private void setCapability(Capability capability) {
            this.setCapability(capability.getType(), capability);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Keys {
        private String publicKey;
        private String privateKey;

        @JsonProperty(value="public_key")
        public String getPublicKey() {
            return this.publicKey;
        }

        @JsonProperty(value="private_key")
        public String getPrivateKey() {
            return this.privateKey;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Privacy {
        private Boolean improveAi;

        @JsonProperty(value="improve_ai")
        public Boolean getImproveAi() {
            return this.improveAi;
        }
    }
}

