/*
 * Decompiled with CFR 0.152.
 */
package com.vonage.client.application;

import com.vonage.client.QueryParamsRequest;
import java.util.LinkedHashMap;
import java.util.Map;

public class ListApplicationRequest
implements QueryParamsRequest {
    private final int pageSize;
    private final int page;

    private ListApplicationRequest(Builder builder) {
        this.pageSize = builder.pageSize;
        this.page = builder.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPage() {
        return this.page;
    }

    public Map<String, String> makeParams() {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(4);
        if (this.page > 0) {
            params.put("page", String.valueOf(this.page));
        }
        if (this.pageSize > 0) {
            params.put("page_size", String.valueOf(this.pageSize));
        }
        return params;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private int pageSize;
        private int page;

        public Builder pageSize(long pageSize) {
            this.pageSize = (int)pageSize;
            return this;
        }

        public Builder page(long page) {
            this.page = (int)page;
            return this;
        }

        public ListApplicationRequest build() {
            return new ListApplicationRequest(this);
        }
    }
}

